/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.events;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.NextMatcher;
import com.sonar.sslr.impl.matcher.NotMatcher;
import com.sonar.sslr.impl.matcher.TokenMatcher;
import com.sonar.sslr.impl.matcher.TokenTypeMatcher;
import com.sonar.sslr.impl.matcher.TokenValueMatcher;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoCompleter
extends ParsingEventListener {
    private static final int MAX_TOKENS = 5;
    private List<List<Token>> partialMatches;
    private List<List<Token>> fullMatches;
    private final Set<TokenMatcher> followingTokenMatchers = new HashSet<TokenMatcher>();
    private List<List<Token>> prefixes = new LinkedList<List<Token>>();
    private int predicateLevel;

    private boolean isPredicateMatcher(Matcher matcher) {
        return matcher instanceof NotMatcher || matcher instanceof NextMatcher;
    }

    private Token tokenMatcherToToken(TokenMatcher tokenMatcher) {
        if (tokenMatcher instanceof TokenValueMatcher) {
            return this.createToken(GenericTokenType.LITERAL, ((TokenValueMatcher)tokenMatcher).getTokenValue());
        }
        if (tokenMatcher instanceof TokenTypeMatcher) {
            return this.createToken(((TokenTypeMatcher)tokenMatcher).getType(), ((TokenTypeMatcher)tokenMatcher).getType().getValue());
        }
        throw new UnsupportedOperationException("tokenMatcherToToken() does not handle class " + tokenMatcher.getClass());
    }

    private Token createToken(TokenType type, String value) {
        try {
            return Token.builder().setType(type).setValueAndOriginalValue(value).setURI(new URI("autocompleter://autocompleter")).setLine(1).setColumn(1).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void enterMatcher(Matcher matcher, ParsingState parsingState) {
        if (this.isPredicateMatcher(matcher)) {
            ++this.predicateLevel;
        }
    }

    @Override
    public void exitWithMatchMatcher(Matcher matcher, ParsingState parsingState, AstNode astNode) {
        if (this.isPredicateMatcher(matcher)) {
            --this.predicateLevel;
        }
    }

    @Override
    public void exitWithoutMatchMatcher(Matcher matcher, ParsingState parsingState) {
        if (this.predicateLevel == 0 && parsingState.lexerIndex == parsingState.lexerSize && matcher instanceof TokenMatcher) {
            this.followingTokenMatchers.add((TokenMatcher)matcher);
        }
        if (this.isPredicateMatcher(matcher)) {
            --this.predicateLevel;
        }
    }

    public void autoComplete(Matcher matcher) {
        this.autoComplete(matcher, new LinkedList<Token>());
    }

    public void autoComplete(Matcher matcher, int maxTokens) {
        this.autoComplete(matcher, new LinkedList<Token>(), maxTokens);
    }

    public void autoComplete(Matcher matcher, List<Token> tokens) {
        this.autoComplete(matcher, tokens, 5);
    }

    public void autoComplete(Matcher matcher, List<Token> tokens, int maxTokens) {
        this.partialMatches = new LinkedList<List<Token>>();
        this.fullMatches = new LinkedList<List<Token>>();
        int maxLength = tokens.size() + maxTokens;
        this.prefixes.clear();
        this.prefixes.add(tokens);
        this.predicateLevel = 0;
        while (!this.prefixes.isEmpty()) {
            LinkedList<List<Token>> newPrefixes = new LinkedList<List<Token>>();
            for (List<Token> prefix : this.prefixes) {
                ParsingState parsingState = new ParsingState(prefix);
                parsingState.parsingEventListeners = new ParsingEventListener[]{this};
                try {
                    this.followingTokenMatchers.clear();
                    matcher.match(parsingState);
                    this.fullMatches.add(prefix);
                }
                catch (BacktrackingEvent re) {
                    if (this.followingTokenMatchers.isEmpty()) {
                        throw new IllegalStateException("Matcher did not match and did not consume any additional TokenMatcher (this should never happen when using only Standard matchers).");
                    }
                    if (prefix.size() < maxLength) {
                        for (TokenMatcher followingTokenMatcher : this.followingTokenMatchers) {
                            LinkedList<Token> newPrefix = new LinkedList<Token>();
                            newPrefix.addAll(prefix);
                            newPrefix.add(this.tokenMatcherToToken(followingTokenMatcher));
                            newPrefixes.add(newPrefix);
                        }
                        continue;
                    }
                    this.partialMatches.add(prefix);
                }
            }
            this.prefixes = newPrefixes;
        }
    }

    public List<List<Token>> getFullMatches() {
        return this.fullMatches;
    }

    public List<List<Token>> getPartialMatches() {
        return this.partialMatches;
    }
}

