/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.events;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.events.ProfilerStream;
import com.sonar.sslr.impl.matcher.MemoizedMatcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public final class Profiler
extends ParsingEventListener {
    public Map<RuleMatcher, RuleCounter> ruleStats;
    private Stack<Timer> timers;
    private Stack<Match> matches;
    private Timer lexerTimer;
    private Timer parserTimer;

    public Profiler() {
        this.initialize();
    }

    public void initialize() {
        this.ruleStats = new HashMap<RuleMatcher, RuleCounter>();
        this.timers = new Stack();
        this.matches = new Stack();
        this.lexerTimer = new Timer();
        this.parserTimer = new Timer();
    }

    public void beginLex() {
        this.lexerTimer.start();
    }

    public void endLex() {
        this.lexerTimer.stop();
    }

    public void beginParse() {
        this.parserTimer.start();
    }

    public void endParse() {
        this.parserTimer.stop();
    }

    public void enterRule(RuleMatcher rule, ParsingState parsingState) {
        this.getRuleCounter(rule).hit();
        this.startMatch(parsingState);
        this.startRecordingTime();
    }

    public void exitWithMatchRule(RuleMatcher rule, ParsingState parsingState, AstNode astNode) {
        this.stopMatch(rule, parsingState, false);
        this.stopRecordingTime(rule);
    }

    public void exitWithoutMatchRule(RuleMatcher rule, ParsingState parsingState) {
        this.stopMatch(rule, parsingState, true);
        this.stopRecordingTime(rule);
    }

    public void memoizerHit(MemoizedMatcher matcher, ParsingState parsingState) {
        if (matcher instanceof RuleMatcher) {
            this.matches.peek().wasMemoized = true;
            this.abortRecordingTime();
            this.getRuleCounter((RuleMatcher)matcher).memoizedHit();
        }
    }

    public void memoizerMiss(MemoizedMatcher matcher, ParsingState parsingState) {
        if (matcher instanceof RuleMatcher) {
            this.getRuleCounter((RuleMatcher)matcher).memoizedMiss();
        }
    }

    public long getLexerCpuTime() {
        return this.lexerTimer.cpuTime;
    }

    public long getParserCpuTime() {
        return this.parserTimer.cpuTime;
    }

    public long getHits() {
        long hits = 0L;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            hits += (long)counter.hits;
        }
        return hits;
    }

    public long getBacktracks() {
        long backtracks = 0L;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            backtracks += (long)counter.backtracks;
        }
        return backtracks;
    }

    public double getAverageBacktrackCpuTime() {
        double totalBacktracksCpuTime = 0.0;
        long backtracks = 0L;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            totalBacktracksCpuTime += (double)counter.totalBacktracksCpuTime;
            backtracks += counter.backtracksCpuTimeCounter;
        }
        return backtracks == 0L ? 0.0 : totalBacktracksCpuTime / (double)backtracks;
    }

    public long getMaxBacktrackCpuTime() {
        long maxBacktrackCpuTime = 0L;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            if (counter.getMaxBacktrackCpuTime() <= maxBacktrackCpuTime) continue;
            maxBacktrackCpuTime = counter.getMaxBacktrackCpuTime();
        }
        return maxBacktrackCpuTime;
    }

    public double getAverageLookahead() {
        double totalLookahead = 0.0;
        int lookaheadsCounter = 0;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            totalLookahead += (double)counter.totalLookaheads;
            lookaheadsCounter += counter.lookaheadsCounter;
        }
        return lookaheadsCounter == 0 ? 0.0 : totalLookahead / (double)lookaheadsCounter;
    }

    public int getMaxLookahead() {
        int maxLookahead = 0;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            if (counter.getMaxLookahead() <= maxLookahead) continue;
            maxLookahead = counter.getMaxLookahead();
        }
        return maxLookahead;
    }

    public long getMemoizedHits() {
        long memoizerHits = 0L;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            memoizerHits += (long)counter.memoizedHits;
        }
        return memoizerHits;
    }

    public long getMemoizedMisses() {
        long memoizerMisses = 0L;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            memoizerMisses += (long)counter.memoizedMisses;
        }
        return memoizerMisses;
    }

    public long getTotalNonMemoizedHitCpuTime() {
        long totalNonMemoizedHitCpuTime = 0L;
        for (Map.Entry<RuleMatcher, RuleCounter> rule : this.ruleStats.entrySet()) {
            RuleCounter counter = rule.getValue();
            totalNonMemoizedHitCpuTime += counter.getTotalNonMemoizedHitCpuTime();
        }
        return totalNonMemoizedHitCpuTime;
    }

    private RuleCounter getRuleCounter(RuleMatcher rule) {
        RuleCounter counter = this.ruleStats.get(rule);
        if (counter == null) {
            counter = new RuleCounter();
            this.ruleStats.put(rule, counter);
        }
        return counter;
    }

    private void startMatch(ParsingState parsingState) {
        Match match = new Match();
        match.startIndex = parsingState.lexerIndex;
        match.wasMemoized = false;
        match.timer.start();
        this.matches.push(match);
    }

    private void stopMatch(RuleMatcher rule, ParsingState parsingState, boolean backtrack) {
        Match match = this.matches.pop();
        if (!match.wasMemoized) {
            RuleCounter counter = this.getRuleCounter(rule);
            if (!backtrack) {
                counter.match();
            } else {
                match.timer.stop();
                counter.backtrack();
                counter.addBacktrackCpuTime(match.timer.cpuTime);
                int lookahead = parsingState.lexerIndex - match.startIndex + 1;
                counter.addLookahead(lookahead);
            }
        }
    }

    private void startRecordingTime() {
        if (this.timers.size() > 0) {
            Timer oldTimer = this.timers.pop();
            if (!oldTimer.isAborted) {
                oldTimer.stop();
            }
            this.timers.push(oldTimer);
        }
        Timer newTimer = new Timer();
        newTimer.start();
        this.timers.push(newTimer);
    }

    private void stopRecordingTime(RuleMatcher rule) {
        Timer currentTimer = this.timers.pop();
        if (!currentTimer.isAborted) {
            currentTimer.stop();
            this.getRuleCounter(rule).addNonMemoizedHitCpuTime(currentTimer.cpuTime);
        }
        if (this.timers.size() > 0) {
            Timer previousTimer = this.timers.pop();
            if (!previousTimer.isAborted) {
                previousTimer.start();
            }
            this.timers.push(previousTimer);
        }
    }

    private void abortRecordingTime() {
        this.timers.peek().abort();
    }

    private static long getCpuTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        PrintStream stream = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            stream = new PrintStream(baos);
            ProfilerStream.print(this, stream);
            String string = baos.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static class Match {
        private int startIndex = -1;
        private boolean wasMemoized = false;
        private final Timer timer = new Timer();

        private Match() {
        }
    }

    private static class Timer {
        private boolean isTiming = false;
        private boolean isAborted = false;
        private long cpuTime = 0L;
        private long start = 0L;

        private Timer() {
        }

        private void start() {
            if (this.isAborted) {
                throw new IllegalStateException();
            }
            this.start = Profiler.getCpuTime();
            this.isTiming = true;
        }

        private void stop() {
            if (!this.isTiming) {
                throw new IllegalStateException();
            }
            this.cpuTime += Profiler.getCpuTime() - this.start;
            this.isTiming = false;
        }

        private void abort() {
            this.isTiming = false;
            this.isAborted = true;
        }
    }

    public static class RuleCounter {
        private int hits = 0;
        private int matches = 0;
        private int backtracks = 0;
        private int memoizedHits = 0;
        private int memoizedMisses = 0;
        private long totalNonMemoizedHitsCpuTime = 0L;
        private int maxLookahead = 0;
        private long totalLookaheads = 0L;
        private int lookaheadsCounter = 0;
        private long maxBacktrackCpuTime = 0L;
        private long totalBacktracksCpuTime = 0L;
        private long backtracksCpuTimeCounter;

        private void hit() {
            ++this.hits;
        }

        private void match() {
            ++this.matches;
        }

        private void backtrack() {
            ++this.backtracks;
        }

        private void memoizedHit() {
            ++this.memoizedHits;
        }

        private void memoizedMiss() {
            ++this.memoizedMisses;
        }

        private void addNonMemoizedHitCpuTime(long cpuTime) {
            this.totalNonMemoizedHitsCpuTime += cpuTime;
        }

        private void addLookahead(int lookahead) {
            if (lookahead > this.maxLookahead) {
                this.maxLookahead = lookahead;
            }
            this.totalLookaheads += (long)lookahead;
            ++this.lookaheadsCounter;
        }

        private void addBacktrackCpuTime(long cpuTime) {
            if (cpuTime > this.maxBacktrackCpuTime) {
                this.maxBacktrackCpuTime = cpuTime;
            }
            this.totalBacktracksCpuTime += cpuTime;
            ++this.backtracksCpuTimeCounter;
        }

        public long getTotalNonMemoizedHitCpuTime() {
            return this.totalNonMemoizedHitsCpuTime;
        }

        public double getAverageLookahead() {
            return this.lookaheadsCounter == 0 ? 0.0 : (double)this.totalLookaheads / (double)this.lookaheadsCounter;
        }

        public int getMaxLookahead() {
            return this.maxLookahead;
        }

        public double getAverageBacktracksCpuTime() {
            return this.backtracksCpuTimeCounter == 0L ? 0.0 : (double)this.totalBacktracksCpuTime / (double)this.backtracksCpuTimeCounter;
        }

        public long getMaxBacktrackCpuTime() {
            return this.maxBacktrackCpuTime;
        }

        public int getHits() {
            return this.hits;
        }

        public int getMatches() {
            return this.matches;
        }

        public int getBacktracks() {
            return this.backtracks;
        }

        public int getMemoizedHits() {
            return this.memoizedHits;
        }

        public int getMemoizedMisses() {
            return this.memoizedMisses;
        }
    }
}

