/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.sonar.channel.ChannelException;
import org.sonar.channel.CodeReaderConfiguration;
import org.sonar.channel.CodeReaderFilter;

public class CodeBuffer
implements CharSequence {
    private final Reader code;
    private int lastChar = -1;
    private Cursor cursor;
    private int bufferCapacity;
    private char[] buffer;
    private int bufferPosition = 0;
    private int bufferSize = 0;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private int tabWidth;
    private boolean recordingMode = false;
    private StringBuilder recordedCharacters = new StringBuilder();

    protected CodeBuffer(Reader initialCodeReader, CodeReaderConfiguration configuration) {
        this.cursor = new Cursor();
        this.bufferCapacity = configuration.getBufferCapacity();
        this.tabWidth = configuration.getTabWidth();
        this.buffer = new char[this.bufferCapacity];
        Reader reader = initialCodeReader;
        for (CodeReaderFilter codeReaderFilter : configuration.getCodeReaderFilters()) {
            reader = new Filter(reader, codeReaderFilter, configuration);
        }
        this.code = reader;
        this.fillBuffer();
    }

    protected CodeBuffer(String code, CodeReaderConfiguration configuration) {
        this(new StringReader(code), configuration);
    }

    public final int pop() {
        if (this.bufferPosition == this.bufferSize) {
            this.fillBuffer();
        }
        if (this.bufferSize == 0) {
            return -1;
        }
        int character = this.buffer[this.bufferPosition++];
        this.updateCursorPosition(character);
        if (this.recordingMode) {
            this.recordedCharacters.append((char)character);
        }
        this.lastChar = character;
        return character;
    }

    private void updateCursorPosition(int character) {
        if (character == 10 || character == 13 && this.peek() != 10) {
            this.cursor.line++;
            this.cursor.column = 0;
        } else if (character == 9) {
            this.cursor.column += this.tabWidth;
        } else {
            this.cursor.column++;
        }
    }

    private int fillBuffer() {
        try {
            int offset = this.bufferSize - this.bufferPosition;
            if (offset != 0) {
                System.arraycopy(this.buffer, this.bufferPosition, this.buffer, 0, this.bufferSize - this.bufferPosition);
            }
            this.bufferPosition = 0;
            int numberOfChars = this.code.read(this.buffer, offset, this.bufferCapacity - offset);
            if (numberOfChars == -1) {
                numberOfChars = 0;
            }
            this.bufferSize = numberOfChars + offset;
            return offset;
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
    }

    public final int lastChar() {
        return this.lastChar;
    }

    public final int peek() {
        return this.intAt(0);
    }

    public void push(CharSequence chars) {
        int length = chars.length();
        if (this.bufferPosition >= length) {
            for (int index = 0; index < length; ++index) {
                this.buffer[this.bufferPosition + index - length] = chars.charAt(index);
            }
            this.bufferPosition -= length;
        } else {
            char[] extendedBuffer = new char[this.buffer.length - this.bufferPosition + length];
            for (int index = 0; index < length; ++index) {
                extendedBuffer[index] = chars.charAt(index);
            }
            System.arraycopy(this.buffer, this.bufferPosition, extendedBuffer, length, this.bufferSize - this.bufferPosition);
            this.buffer = extendedBuffer;
            this.bufferSize = this.bufferSize + length - this.bufferPosition;
            this.bufferPosition = 0;
        }
    }

    public final void close() {
        IOUtils.closeQuietly(this.code);
    }

    public final int getLinePosition() {
        return this.cursor.line;
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final int getColumnPosition() {
        return this.cursor.column;
    }

    public final CodeBuffer setColumnPosition(int cp) {
        this.cursor.column = cp;
        return this;
    }

    public final void setLinePosition(int lp) {
        this.cursor.line = lp;
    }

    public final void startRecording() {
        this.recordingMode = true;
    }

    public final CharSequence stopRecording() {
        this.recordingMode = false;
        StringBuilder result = this.recordedCharacters;
        this.recordedCharacters = new StringBuilder();
        return result;
    }

    public final char charAt(int index) {
        return (char)this.intAt(index);
    }

    protected final int intAt(int index) {
        if (this.bufferPosition + index > this.bufferSize - 1) {
            this.fillBuffer();
        }
        if (this.bufferPosition + index > this.bufferSize - 1) {
            return -1;
        }
        return this.buffer[this.bufferPosition + index];
    }

    public final int length() {
        return this.bufferSize == this.bufferCapacity ? Integer.MAX_VALUE : this.bufferSize - this.bufferPosition;
    }

    public final CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CodeReader(");
        result.append("line:").append(this.cursor.line);
        result.append("|column:").append(this.cursor.column);
        result.append("|cursor value:'").append((char)this.peek()).append("'");
        result.append(")");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Filter
    extends FilterReader {
        private CodeReaderFilter<?> codeReaderFilter;

        public Filter(Reader in, CodeReaderFilter<?> codeReaderFilter, CodeReaderConfiguration configuration) {
            super(in);
            this.codeReaderFilter = codeReaderFilter;
            this.codeReaderFilter.setConfiguration(configuration.cloneWithoutCodeReaderFilters());
            this.codeReaderFilter.setReader(in);
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.codeReaderFilter.read(cbuf, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public final class Cursor
    implements Cloneable {
        private int line = 1;
        private int column = 0;

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public Cursor clone() {
            Cursor clone = new Cursor();
            clone.column = this.column;
            clone.line = this.line;
            return clone;
        }
    }
}

