/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SourceCodeBuilderCallback;
import com.sonar.sslr.squid.SourceCodeBuilderVisitor;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.SquidAstVisitorContextImpl;
import com.sonar.sslr.squid.metrics.CommentsVisitor;
import com.sonar.sslr.squid.metrics.ComplexityVisitor;
import com.sonar.sslr.squid.metrics.CounterVisitor;
import com.sonar.sslr.squid.metrics.LinesOfCodeVisitor;
import com.sonar.sslr.squid.metrics.LinesVisitor;
import java.io.File;
import java.util.Collection;
import org.sonar.flex.FlexConfiguration;
import org.sonar.flex.FlexSquidPackage;
import org.sonar.flex.api.FlexGrammar;
import org.sonar.flex.api.FlexMetric;
import org.sonar.flex.api.FlexPunctuator;
import org.sonar.flex.parser.FlexParser;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlexAstScanner {
    private FlexAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<FlexGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<FlexGrammar> scanner = FlexAstScanner.create(new FlexConfiguration(), visitors);
        scanner.scanFile(file);
        Collection<SourceCode> sources = scanner.getIndex().search(new QueryByType(SourceFile.class));
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<FlexGrammar> create(FlexConfiguration conf, SquidAstVisitor<FlexGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("Flex Project"));
        final Parser<FlexGrammar> parser = FlexParser.create(conf, new ParsingEventListener[0]);
        AstScanner.Builder builder = AstScanner.builder((SquidAstVisitorContextImpl)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])FlexMetric.values());
        builder.setCommentAnalyser(new CommentAnalyser(){

            public boolean isBlank(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isLetterOrDigit(line.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            public String getContents(String comment) {
                return comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
            }
        });
        builder.setFilesMetric((MetricDef)FlexMetric.FILES);
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String packageName;
                AstNode packageNameNode = astNode.getChild(1);
                if (packageNameNode.is(((FlexGrammar)parser.getGrammar()).identifier)) {
                    StringBuilder sb = new StringBuilder();
                    for (AstNode part : packageNameNode.getChildren()) {
                        sb.append(part.getTokenValue());
                    }
                    packageName = sb.toString();
                } else {
                    packageName = "";
                }
                return new FlexSquidPackage(packageName);
            }
        }, new AstNodeType[]{parser.getGrammar().packageDecl}));
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String className = astNode.getChild(1).getTokenValue();
                SourceClass cls = new SourceClass(className + ":" + astNode.getToken().getLine());
                cls.setStartAtLine(astNode.getTokenLine());
                return cls;
            }
        }, new AstNodeType[]{parser.getGrammar().classDefinition, parser.getGrammar().interfaceDefinition}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)FlexMetric.CLASSES).subscribeTo(new AstNodeType[]{parser.getGrammar().classDefinition, parser.getGrammar().interfaceDefinition}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.getChild(1).getTokenValue();
                SourceFunction function = new SourceFunction(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{parser.getGrammar().methodDefinition, parser.getGrammar().functionExpression}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)FlexMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{parser.getGrammar().methodDefinition, parser.getGrammar().functionExpression}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)FlexMetric.LINES));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesOfCodeVisitor((MetricDef)FlexMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)FlexMetric.COMMENT_LINES).withBlankCommentMetric((MetricDef)FlexMetric.COMMENT_BLANK_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)FlexMetric.STATEMENTS).subscribeTo(new AstNodeType[]{parser.getGrammar().labelledStatement, parser.getGrammar().defaultXmlNamespaceStatement, parser.getGrammar().declarationStatement, parser.getGrammar().expressionStatement, parser.getGrammar().ifStatement, parser.getGrammar().forEachStatement, parser.getGrammar().forStatement, parser.getGrammar().whileStatement, parser.getGrammar().doWhileStatement, parser.getGrammar().withStatement, parser.getGrammar().switchStatement, parser.getGrammar().breakStatement, parser.getGrammar().continueStatement, parser.getGrammar().returnStatement, parser.getGrammar().throwStatement, parser.getGrammar().tryStatement, parser.getGrammar().includeDirective, parser.getGrammar().emptyStatement}).build());
        AstNodeType[] complexityAstNodeType = new AstNodeType[]{parser.getGrammar().methodDefinition, parser.getGrammar().functionExpression, parser.getGrammar().ifStatement, parser.getGrammar().forStatement, parser.getGrammar().forEachStatement, parser.getGrammar().whileStatement, parser.getGrammar().doWhileStatement, parser.getGrammar().switchStatement, parser.getGrammar().caseClause, parser.getGrammar().defaultClause, parser.getGrammar().catchBlock, parser.getGrammar().returnStatement, parser.getGrammar().throwStatement, FlexPunctuator.QUESTION, FlexPunctuator.LAND, FlexPunctuator.LOR};
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)FlexMetric.COMPLEXITY).subscribeTo(complexityAstNodeType).build());
        for (SquidAstVisitor<FlexGrammar> visitor : visitors) {
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

