/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import org.sonar.flex.FlexConfiguration;
import org.sonar.flex.api.FlexKeyword;
import org.sonar.flex.api.FlexPunctuator;
import org.sonar.flex.api.FlexTokenType;
import org.sonar.flex.lexer.FlexRegularExpressionLiteralChannel;

public final class FlexLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";

    private FlexLexer() {
    }

    public static Lexer create() {
        return FlexLexer.create(new FlexConfiguration());
    }

    public static Lexer create(FlexConfiguration conf) {
        return Lexer.builder().withCharset(conf.getCharset()).withFailIfNoChannelToConsumeOneCharacter(true).withChannel(RegexpChannelBuilder.commentRegexp("//[^\\n\\r]*+")).withChannel(RegexpChannelBuilder.commentRegexp("/\\*[\\s\\S]*?\\*/")).withChannel(RegexpChannelBuilder.regexp(GenericTokenType.LITERAL, "\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"")).withChannel(RegexpChannelBuilder.regexp(GenericTokenType.LITERAL, "'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'")).withChannel(new FlexRegularExpressionLiteralChannel()).withChannel(RegexpChannelBuilder.regexp(FlexTokenType.NUMERIC_LITERAL, "0[xX][0-9a-fA-F]++")).withChannel(RegexpChannelBuilder.regexp(FlexTokenType.NUMERIC_LITERAL, "[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+")).withChannel(RegexpChannelBuilder.regexp(FlexTokenType.NUMERIC_LITERAL, "\\.[0-9]++([Ee][+-]?+[0-9_]++)?+")).withChannel(RegexpChannelBuilder.regexp(FlexTokenType.NUMERIC_LITERAL, "[0-9]++([Ee][+-]?+[0-9_]++)?+")).withChannel(new IdentifierAndKeywordChannel("\\p{javaJavaIdentifierStart}++[\\p{javaJavaIdentifierPart}\\-]*+", true, new TokenType[][]{FlexKeyword.values()})).withChannel(new PunctuatorChannel(FlexPunctuator.values())).withChannel(new BlackHoleChannel("[\\s]")).withChannel(RegexpChannelBuilder.regexp(FlexTokenType.UNKNOWN, ".")).build();
    }
}

