/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cobertura;

import org.apache.commons.configuration.Configuration;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.Initializer;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.plugins.cobertura.CoberturaMavenPluginHandler;
import org.sonar.plugins.cobertura.CoberturaSettings;

public class CoberturaMavenInitializer
extends Initializer
implements CoverageExtension,
DependsUponMavenPlugin {
    private CoberturaMavenPluginHandler handler;
    private CoberturaSettings coberturaSettings;

    public CoberturaMavenInitializer(CoberturaMavenPluginHandler handler, CoberturaSettings coberturaSettings) {
        this.handler = handler;
        this.coberturaSettings = coberturaSettings;
    }

    public MavenPluginHandler getMavenPluginHandler(Project project) {
        return project.getAnalysisType().equals((Object)Project.AnalysisType.DYNAMIC) ? this.handler : null;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.coberturaSettings.isEnabled(project);
    }

    public void execute(Project project) {
        Configuration conf = project.getConfiguration();
        if (!conf.containsKey("sonar.cobertura.reportPath")) {
            String report = CoberturaMavenInitializer.getReportPathFromPluginConfiguration(project);
            if (report == null) {
                report = CoberturaMavenInitializer.getDefaultReportPath(project);
            }
            conf.setProperty("sonar.cobertura.reportPath", (Object)report);
        }
    }

    private static String getDefaultReportPath(Project project) {
        return project.getFileSystem().getReportOutputDir() + "/cobertura/coverage.xml";
    }

    private static String getReportPathFromPluginConfiguration(Project project) {
        String path;
        MavenPlugin mavenPlugin = MavenPlugin.getPlugin((MavenProject)project.getPom(), (String)"org.codehaus.mojo", (String)"cobertura-maven-plugin");
        if (mavenPlugin != null && (path = mavenPlugin.getParameter("outputDirectory")) != null) {
            return path + "/coverage.xml";
        }
        return null;
    }
}

