/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cobertura;

import java.io.File;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.cobertura.CoberturaSettings;
import org.sonar.plugins.cobertura.api.AbstractCoberturaParser;

public class CoberturaSensor
implements Sensor,
CoverageExtension {
    private CoberturaSettings settings;

    public CoberturaSensor(CoberturaSettings settings) {
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.settings.isEnabled(project);
    }

    public void analyse(Project project, SensorContext context) {
        String path = (String)project.getProperty("sonar.cobertura.reportPath");
        if (path == null) {
            return;
        }
        File report = project.getFileSystem().resolvePath(path);
        if (!report.exists() || !report.isFile()) {
            LoggerFactory.getLogger(this.getClass()).warn("Cobertura report not found at {}", (Object)report);
            return;
        }
        this.parseReport(report, context);
    }

    protected void parseReport(File xmlFile, SensorContext context) {
        LoggerFactory.getLogger(CoberturaSensor.class).info("parsing {}", (Object)xmlFile);
        new JavaCoberturaParser().parseReport(xmlFile, context);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JavaCoberturaParser
    extends AbstractCoberturaParser {
        private JavaCoberturaParser() {
        }

        protected Resource<?> getResource(String fileName) {
            return new JavaFile(fileName);
        }
    }
}

