/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cobertura.api;

import com.google.common.collect.Maps;
import java.io.File;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.api.utils.XmlParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCoberturaParser {
    public void parseReport(File xmlFile, final SensorContext context) {
        try {
            StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

                public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                    try {
                        rootCursor.advance();
                        AbstractCoberturaParser.this.collectPackageMeasures(rootCursor.descendantElementCursor("package"), context);
                    }
                    catch (ParseException e) {
                        throw new XMLStreamException(e);
                    }
                }
            });
            parser.parse(xmlFile);
        }
        catch (XMLStreamException e) {
            throw new XmlParserException((Throwable)e);
        }
    }

    private void collectPackageMeasures(SMInputCursor pack, SensorContext context) throws ParseException, XMLStreamException {
        while (pack.getNext() != null) {
            HashMap builderByFilename = Maps.newHashMap();
            this.collectFileMeasures(pack.descendantElementCursor("class"), builderByFilename);
            for (Map.Entry entry : builderByFilename.entrySet()) {
                String filename = this.sanitizeFilename((String)entry.getKey());
                Resource file = this.getResource(filename);
                if (!this.fileExists(context, file)) continue;
                for (Measure measure : ((CoverageMeasuresBuilder)entry.getValue()).createMeasures()) {
                    context.saveMeasure(file, measure);
                }
            }
        }
    }

    private boolean fileExists(SensorContext context, Resource file) {
        return context.getResource(file) != null;
    }

    private void collectFileMeasures(SMInputCursor clazz, Map<String, CoverageMeasuresBuilder> builderByFilename) throws ParseException, XMLStreamException {
        while (clazz.getNext() != null) {
            String fileName = clazz.getAttrValue("filename");
            CoverageMeasuresBuilder builder = builderByFilename.get(fileName);
            if (builder == null) {
                builder = CoverageMeasuresBuilder.create();
                builderByFilename.put(fileName, builder);
            }
            this.collectFileData(clazz, builder);
        }
    }

    private void collectFileData(SMInputCursor clazz, CoverageMeasuresBuilder builder) throws ParseException, XMLStreamException {
        SMInputCursor line = clazz.childElementCursor("lines").advance().childElementCursor("line");
        while (line.getNext() != null) {
            int lineId = Integer.parseInt(line.getAttrValue("number"));
            builder.setHits(lineId, (int)ParsingUtils.parseNumber((String)line.getAttrValue("hits"), (Locale)Locale.ENGLISH));
            String isBranch = line.getAttrValue("branch");
            String text = line.getAttrValue("condition-coverage");
            if (!StringUtils.equals((String)isBranch, (String)"true") || !StringUtils.isNotBlank((String)text)) continue;
            String[] conditions = StringUtils.split((String)StringUtils.substringBetween((String)text, (String)"(", (String)")"), (String)"/");
            builder.setConditions(lineId, Integer.parseInt(conditions[1]), Integer.parseInt(conditions[0]));
        }
    }

    private String sanitizeFilename(String s) {
        String fileName = FilenameUtils.removeExtension((String)s);
        fileName = fileName.replace('/', '.').replace('\\', '.');
        return fileName;
    }

    protected abstract Resource getResource(String var1);
}

