/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cobertura.api;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.Logs;

public final class CoberturaUtils {
    public static final String COBERTURA_GROUP_ID = "org.codehaus.mojo";
    public static final String COBERTURA_ARTIFACT_ID = "cobertura-maven-plugin";

    @Deprecated
    public static File getReport(Project project) {
        File report = CoberturaUtils.getReportFromProperty(project);
        if (report == null) {
            report = CoberturaUtils.getReportFromPluginConfiguration(project);
        }
        if (report == null) {
            report = CoberturaUtils.getReportFromDefaultPath(project);
        }
        if (report == null || !report.exists() || !report.isFile()) {
            Logs.INFO.warn("Cobertura report not found at {}", (Object)report);
            report = null;
        }
        return report;
    }

    private static File getReportFromProperty(Project project) {
        String path = (String)project.getProperty("sonar.cobertura.reportPath");
        if (path != null) {
            return project.getFileSystem().resolvePath(path);
        }
        return null;
    }

    private static File getReportFromPluginConfiguration(Project project) {
        String path;
        MavenPlugin mavenPlugin = MavenPlugin.getPlugin((MavenProject)project.getPom(), (String)COBERTURA_GROUP_ID, (String)COBERTURA_ARTIFACT_ID);
        if (mavenPlugin != null && (path = mavenPlugin.getParameter("outputDirectory")) != null) {
            return new File(project.getFileSystem().resolvePath(path), "coverage.xml");
        }
        return null;
    }

    private static File getReportFromDefaultPath(Project project) {
        return new File(project.getFileSystem().getReportOutputDir(), "cobertura/coverage.xml");
    }

    private CoberturaUtils() {
    }
}

