/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.WildcardMatcher;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.test.MutableTestCase;
import org.sonar.api.test.MutableTestPlan;
import org.sonar.api.test.MutableTestable;
import org.sonar.api.test.Testable;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.ExecutionDataVisitor;
import org.sonar.plugins.jacoco.JaCoCoUtils;

public abstract class AbstractAnalyzer {
    private final ResourcePerspectives perspectives;
    private final ModuleFileSystem fileSystem;
    private final PathResolver pathResolver;

    public AbstractAnalyzer(ResourcePerspectives perspectives, ModuleFileSystem fileSystem, PathResolver pathResolver) {
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    private static boolean isExcluded(ISourceFileCoverage coverage, WildcardMatcher excludesMatcher) {
        String name = coverage.getPackageName() + "/" + coverage.getName();
        return excludesMatcher.matches(name);
    }

    @VisibleForTesting
    static JavaFile getResource(ISourceFileCoverage coverage, SensorContext context) {
        String fileName;
        String packageName = StringUtils.replaceChars((String)coverage.getPackageName(), (char)'/', (char)'.');
        JavaFile resource = new JavaFile(packageName, fileName = StringUtils.substringBeforeLast((String)coverage.getName(), (String)"."));
        JavaFile resourceInContext = (JavaFile)context.getResource((Resource)resource);
        if (null == resourceInContext) {
            return null;
        }
        if (ResourceUtils.isUnitTestClass((Resource)resourceInContext)) {
            return null;
        }
        return resourceInContext;
    }

    public final void analyse(Project project, SensorContext context) {
        if (!this.atLeastOneBinaryDirectoryExists()) {
            JaCoCoUtils.LOG.info("Project coverage is set to 0% since there is no directories with classes.");
            return;
        }
        String path = this.getReportPath(project);
        File jacocoExecutionData = this.pathResolver.relativeFile(this.fileSystem.baseDir(), path);
        WildcardMatcher excludes = new WildcardMatcher(Strings.nullToEmpty((String)this.getExcludes(project)));
        try {
            this.readExecutionData(jacocoExecutionData, context, excludes);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
    }

    private boolean atLeastOneBinaryDirectoryExists() {
        for (File binaryDir : this.fileSystem.binaryDirs()) {
            if (!binaryDir.exists()) continue;
            return true;
        }
        return false;
    }

    public final void readExecutionData(File jacocoExecutionData, SensorContext context, WildcardMatcher excludes) throws IOException {
        ExecutionDataVisitor executionDataVisitor = new ExecutionDataVisitor();
        if (jacocoExecutionData == null || !jacocoExecutionData.exists() || !jacocoExecutionData.isFile()) {
            JaCoCoUtils.LOG.info("Project coverage is set to 0% as no JaCoCo execution data has been dumped: {}", (Object)jacocoExecutionData);
            jacocoExecutionData = null;
        } else {
            JaCoCoUtils.LOG.info("Analysing {}", (Object)jacocoExecutionData);
            ExecutionDataReader reader = new ExecutionDataReader((InputStream)new FileInputStream(jacocoExecutionData));
            reader.setSessionInfoVisitor((ISessionInfoVisitor)executionDataVisitor);
            reader.setExecutionDataVisitor((IExecutionDataVisitor)executionDataVisitor);
            reader.read();
        }
        boolean collectedCoveragePerTest = false;
        for (Map.Entry<String, ExecutionDataStore> entry : executionDataVisitor.getSessions().entrySet()) {
            if (!this.analyzeLinesCoveredByTests(entry.getKey(), entry.getValue(), context, excludes)) continue;
            collectedCoveragePerTest = true;
        }
        CoverageBuilder coverageBuilder = this.analyze(executionDataVisitor.getMerged());
        int analyzedResources = 0;
        for (ISourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            JavaFile resource = AbstractAnalyzer.getResource(coverage, context);
            if (resource == null) continue;
            if (!AbstractAnalyzer.isExcluded(coverage, excludes)) {
                CoverageMeasuresBuilder builder = this.analyzeFile(resource, coverage);
                this.saveMeasures(context, resource, builder.createMeasures());
            }
            ++analyzedResources;
        }
        if (analyzedResources == 0) {
            JaCoCoUtils.LOG.warn("Coverage information was not collected. Perhaps you forget to include debug information into compiled classes?");
        } else if (collectedCoveragePerTest) {
            JaCoCoUtils.LOG.info("Information about coverage per test has been collected.");
        } else if (jacocoExecutionData != null) {
            JaCoCoUtils.LOG.info("No information about coverage per test.");
        }
    }

    private boolean analyzeLinesCoveredByTests(String sessionId, ExecutionDataStore executionDataStore, SensorContext context, WildcardMatcher excludes) {
        int i = sessionId.indexOf(32);
        if (i < 0) {
            return false;
        }
        String testClassName = sessionId.substring(0, i);
        String testName = sessionId.substring(i + 1);
        Resource testResource = context.getResource((Resource)new JavaFile(testClassName, true));
        if (testResource == null) {
            return false;
        }
        boolean result = false;
        CoverageBuilder coverageBuilder = this.analyze2(executionDataStore);
        for (ISourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            CoverageMeasuresBuilder builder;
            List<Integer> coveredLines;
            JavaFile resource = AbstractAnalyzer.getResource(coverage, context);
            if (resource == null || AbstractAnalyzer.isExcluded(coverage, excludes) || (coveredLines = this.getCoveredLines(builder = this.analyzeFile(resource, coverage))).isEmpty() || !this.addCoverage(resource, testResource, testName, coveredLines)) continue;
            result = true;
        }
        return result;
    }

    private CoverageBuilder analyze2(ExecutionDataStore executionDataStore) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        for (File binaryDir : this.fileSystem.binaryDirs()) {
            for (ExecutionData data : executionDataStore.getContents()) {
                String vmClassName = data.getName();
                String classFileName = vmClassName.replace('.', '/') + ".class";
                File classFile = new File(binaryDir, classFileName);
                if (!classFile.isFile()) continue;
                try {
                    analyzer.analyzeAll(classFile);
                }
                catch (Exception e) {
                    JaCoCoUtils.LOG.warn("Exception during analysis of file " + classFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return coverageBuilder;
    }

    private List<Integer> getCoveredLines(CoverageMeasuresBuilder builder) {
        ArrayList linesCover = Lists.newArrayList();
        for (Map.Entry hitsByLine : builder.getHitsByLine().entrySet()) {
            if ((Integer)hitsByLine.getValue() <= 0) continue;
            linesCover.add(hitsByLine.getKey());
        }
        return linesCover;
    }

    private boolean addCoverage(JavaFile resource, Resource testFile, String testName, List<Integer> coveredLines) {
        MutableTestPlan testPlan;
        boolean result = false;
        Testable testAbleFile = (Testable)this.perspectives.as(MutableTestable.class, (Resource)resource);
        if (testAbleFile != null && (testPlan = (MutableTestPlan)this.perspectives.as(MutableTestPlan.class, testFile)) != null) {
            for (MutableTestCase testCase : testPlan.testCasesByName(testName)) {
                testCase.setCoverageBlock(testAbleFile, coveredLines);
                result = true;
            }
        }
        return result;
    }

    private CoverageBuilder analyze(ExecutionDataStore executionDataStore) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        for (File binaryDir : this.fileSystem.binaryDirs()) {
            this.analyzeAll(analyzer, binaryDir);
        }
        return coverageBuilder;
    }

    private void analyzeAll(Analyzer analyzer, File file) {
        block4: {
            block3: {
                if (!file.isDirectory()) break block3;
                for (File f : file.listFiles()) {
                    this.analyzeAll(analyzer, f);
                }
                break block4;
            }
            if (!file.getName().endsWith(".class")) break block4;
            try {
                analyzer.analyzeAll(file);
            }
            catch (Exception e) {
                JaCoCoUtils.LOG.warn("Exception during analysis of file " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private CoverageMeasuresBuilder analyzeFile(JavaFile resource, ISourceFileCoverage coverage) {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        block5: for (int lineId = coverage.getFirstLine(); lineId <= coverage.getLastLine(); ++lineId) {
            int hits;
            ILine line = coverage.getLine(lineId);
            switch (line.getInstructionCounter().getStatus()) {
                case 2: 
                case 3: {
                    hits = 1;
                    break;
                }
                case 1: {
                    hits = 0;
                    break;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    JaCoCoUtils.LOG.warn("Unknown status for line {} in {}", (Object)lineId, (Object)resource);
                    continue block5;
                }
            }
            builder.setHits(lineId, hits);
            ICounter branchCounter = line.getBranchCounter();
            int conditions = branchCounter.getTotalCount();
            if (conditions <= 0) continue;
            int coveredConditions = branchCounter.getCoveredCount();
            builder.setConditions(lineId, conditions, coveredConditions);
        }
        return builder;
    }

    protected abstract void saveMeasures(SensorContext var1, JavaFile var2, Collection<Measure> var3);

    protected abstract String getReportPath(Project var1);

    protected abstract String getExcludes(Project var1);
}

