/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;

public class ExecutionDataVisitor
implements ISessionInfoVisitor,
IExecutionDataVisitor {
    private final Map<String, ExecutionDataStore> sessions = Maps.newHashMap();
    private ExecutionDataStore executionDataStore;
    private ExecutionDataStore merged = new ExecutionDataStore();

    public void visitSessionInfo(SessionInfo info) {
        String sessionId = info.getId();
        this.executionDataStore = this.sessions.get(sessionId);
        if (this.executionDataStore == null) {
            this.executionDataStore = new ExecutionDataStore();
            this.sessions.put(sessionId, this.executionDataStore);
        }
    }

    public void visitClassExecution(ExecutionData data) {
        this.executionDataStore.put(data);
        this.merged.put(ExecutionDataVisitor.defensiveCopy(data));
    }

    public Map<String, ExecutionDataStore> getSessions() {
        return this.sessions;
    }

    public ExecutionDataStore getMerged() {
        return this.merged;
    }

    private static ExecutionData defensiveCopy(ExecutionData data) {
        boolean[] src = data.getProbes();
        boolean[] dest = new boolean[src.length];
        System.arraycopy(src, 0, dest, 0, src.length);
        return new ExecutionData(data.getId(), data.getName(), dest);
    }
}

