/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JacocoConfiguration;

public class JaCoCoItSensor
implements Sensor {
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final ModuleFileSystem fileSystem;
    private final PathResolver pathResolver;

    public JaCoCoItSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, ModuleFileSystem fileSystem, PathResolver pathResolver) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.configuration.isEnabled(project) && StringUtils.isNotBlank((String)this.configuration.getItReportPath());
    }

    public void analyse(Project project, SensorContext context) {
        new ITAnalyzer(this.perspectives).analyse(project, context);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class ITAnalyzer
    extends AbstractAnalyzer {
        public ITAnalyzer(ResourcePerspectives perspectives) {
            super(perspectives, JaCoCoItSensor.this.fileSystem, JaCoCoItSensor.this.pathResolver);
        }

        @Override
        protected String getReportPath(Project project) {
            return JaCoCoItSensor.this.configuration.getItReportPath();
        }

        @Override
        protected String getExcludes(Project project) {
            return JaCoCoItSensor.this.configuration.getExcludes();
        }

        @Override
        protected void saveMeasures(SensorContext context, JavaFile resource, Collection<Measure> measures) {
            for (Measure measure : measures) {
                Measure itMeasure = this.convertForIT(measure);
                if (itMeasure == null) continue;
                context.saveMeasure((Resource)resource, itMeasure);
            }
        }

        private Measure convertForIT(Measure measure) {
            Measure itMeasure = null;
            if (CoreMetrics.LINES_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_LINES_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_LINES, measure.getValue());
            } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, measure.getData());
            } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_CONDITIONS, measure.getValue());
            } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, measure.getData());
            } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_BY_LINE, measure.getData());
            }
            return itMeasure;
        }
    }
}

