/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.util.Collection;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JacocoConfiguration;

public class JaCoCoSensor
implements Sensor {
    private JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final ModuleFileSystem fileSystem;
    private final PathResolver pathResolver;

    public JaCoCoSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, ModuleFileSystem fileSystem, PathResolver pathResolver) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    @DependsUpon
    public String dependsUponSurefireSensors() {
        return "surefire-java";
    }

    public void analyse(Project project, SensorContext context) {
        new UnitTestsAnalyzer(this.perspectives).analyse(project, context);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.configuration.isEnabled(project);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class UnitTestsAnalyzer
    extends AbstractAnalyzer {
        public UnitTestsAnalyzer(ResourcePerspectives perspectives) {
            super(perspectives, JaCoCoSensor.this.fileSystem, JaCoCoSensor.this.pathResolver);
        }

        @Override
        protected String getReportPath(Project project) {
            return JaCoCoSensor.this.configuration.getReportPath();
        }

        @Override
        protected String getExcludes(Project project) {
            return JaCoCoSensor.this.configuration.getExcludes();
        }

        @Override
        protected void saveMeasures(SensorContext context, JavaFile resource, Collection<Measure> measures) {
            for (Measure measure : measures) {
                context.saveMeasure((Resource)resource, measure);
            }
        }
    }
}

