/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jacoco.core.runtime.AgentOptions;
import org.sonar.api.BatchExtension;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.plugins.jacoco.JaCoCoAgentDownloader;
import org.sonar.plugins.java.api.JavaSettings;

public class JacocoConfiguration
implements BatchExtension {
    public static final String REPORT_PATH_PROPERTY = "sonar.jacoco.reportPath";
    public static final String REPORT_PATH_DEFAULT_VALUE = "target/jacoco.exec";
    public static final String IT_REPORT_PATH_PROPERTY = "sonar.jacoco.itReportPath";
    public static final String IT_REPORT_PATH_DEFAULT_VALUE = "";
    public static final String INCLUDES_PROPERTY = "sonar.jacoco.includes";
    public static final String EXCLUDES_PROPERTY = "sonar.jacoco.excludes";
    public static final String EXCLUDES_DEFAULT_VALUE = "*_javassist_*";
    public static final String EXCLCLASSLOADER_PROPERTY = "sonar.jacoco.exclclassloader";
    public static final String ANT_TARGETS_DEFAULT_VALUE = "";
    private final Settings settings;
    private final JavaSettings javaSettings;
    private final JaCoCoAgentDownloader downloader;

    public JacocoConfiguration(Settings settings, JaCoCoAgentDownloader downloader, JavaSettings javaSettings) {
        this.settings = settings;
        this.downloader = downloader;
        this.javaSettings = javaSettings;
    }

    public boolean isEnabled(Project project) {
        return "java".equals(project.getLanguageKey()) && project.getAnalysisType().isDynamic(true) && "jacoco".equals(this.javaSettings.getEnabledCoveragePlugin());
    }

    public String getReportPath() {
        return this.settings.getString(REPORT_PATH_PROPERTY);
    }

    public String getItReportPath() {
        return this.settings.getString(IT_REPORT_PATH_PROPERTY);
    }

    public String getJvmArgument() {
        String exclclassloader;
        String excludes;
        AgentOptions options = new AgentOptions();
        options.setDestfile(this.getReportPath());
        String includes = Joiner.on((char)':').join((Object[])this.settings.getStringArray(INCLUDES_PROPERTY));
        if (StringUtils.isNotBlank((String)includes)) {
            options.setIncludes(includes);
        }
        if (StringUtils.isNotBlank((String)(excludes = Joiner.on((char)':').join((Object[])this.settings.getStringArray(EXCLUDES_PROPERTY))))) {
            options.setExcludes(excludes);
        }
        if (StringUtils.isNotBlank((String)(exclclassloader = Joiner.on((char)':').join((Object[])this.settings.getStringArray(EXCLCLASSLOADER_PROPERTY))))) {
            options.setExclClassloader(exclclassloader);
        }
        return options.getVMArgument(this.downloader.getAgentJarFile());
    }

    public String getExcludes() {
        return this.settings.getString(EXCLUDES_PROPERTY);
    }

    public static List<PropertyDefinition> getPropertyDefinitions() {
        String subCategory = "JaCoCo";
        return ImmutableList.of((Object)PropertyDefinition.builder((String)REPORT_PATH_PROPERTY).defaultValue(REPORT_PATH_DEFAULT_VALUE).category("java").subCategory(subCategory).name("File with execution data").description("Path (absolute or relative) to the file with execution data.").onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)INCLUDES_PROPERTY).multiValues(true).category("java").subCategory(subCategory).name("Includes").description("A list of class names that should be included in execution analysis (see wildcards). Except for performance optimization or technical corner cases this option is normally not required.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)EXCLUDES_PROPERTY).defaultValue(EXCLUDES_DEFAULT_VALUE).multiValues(true).category("java").subCategory(subCategory).name("Excludes").description("A list of class names that should be excluded from execution analysis (see wildcards). Except for performance optimization or technical corner cases this option is normally not required.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)EXCLCLASSLOADER_PROPERTY).multiValues(true).category("java").subCategory(subCategory).name("Excluded class loaders").description("A list of class loader names that should be excluded from execution analysis (see wildcards). This option might be required in case of special frameworks that conflict with JaCoCo code instrumentation, in particular class loaders that do not have access to the Java runtime classes.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)IT_REPORT_PATH_PROPERTY).defaultValue("").category("java").subCategory(subCategory).name("File with execution data for integration tests").description("Path (absolute or relative) to the file with execution data.").onlyOnQualifiers("TRK", new String[]{"BRC"}).build());
    }
}

