/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jmeter;

import es.excentia.jmeter.report.client.JMeterReportClient;
import es.excentia.jmeter.report.client.data.GlobalSummary;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.plugins.jmeter.JMeterMetrics;
import org.sonar.plugins.jmeter.exception.JMeterPluginException;

public class JMeterSensor
implements Sensor {
    public static final Logger LOG = LoggerFactory.getLogger(JMeterSensor.class);

    public boolean shouldExecuteOnProject(Project project) {
        String config = (String)project.getProperty("org.sonar.plugins.jmeter.server.config");
        return StringUtils.isNotBlank((String)config);
    }

    public void analyse(Project project, SensorContext context) {
        LOG.debug("START JMeterSensor");
        try {
            JMeterReportClient client = this.getReportClient(project);
            String config = this.getTestConfigName(project);
            GlobalSummary summary = client.getGlobalSummary(config);
            context.saveMeasure(JMeterMetrics.requestErrorPercent, Double.valueOf(summary.getRequestsErrorPercent()));
            context.saveMeasure(new Measure(JMeterMetrics.testDesc, summary.getTestDesc()));
            context.saveMeasure(JMeterMetrics.duration, new Double(summary.getTestDuration()));
            context.saveMeasure(JMeterMetrics.usersLogged, new Double(summary.getUsersLogged()));
            context.saveMeasure(JMeterMetrics.requestTotal, new Double(summary.getRequestsTotal()));
            context.saveMeasure(JMeterMetrics.transTotal, new Double(summary.getTransTotal()));
            if (summary.getRequestsTotal() > 0L) {
                context.saveMeasure(JMeterMetrics.requestResponseTimeOkAvg, new Double(summary.getRequestsResponseTimeOkAvg()));
                context.saveMeasure(JMeterMetrics.requestResponseTimeOkDevPercent, new Double(summary.getRequestsResponseTimeOkAvgDevPercent()));
                context.saveMeasure(JMeterMetrics.requestOkPerMinute, new Double(summary.getRequestsOkPerMinute()));
                context.saveMeasure(JMeterMetrics.requestOkPerMinuteAndUser, new Double(summary.getRequestsOkPerMinuteAndUser()));
            }
            if (summary.getTransTotal() > 0L) {
                context.saveMeasure(JMeterMetrics.transResponseTimeOkAvg, new Double(summary.getTransResponseTimeOkAvg()));
                context.saveMeasure(JMeterMetrics.transResponseTimeOkDevPercent, new Double(summary.getTransBytesOkAvgDevPercent()));
                context.saveMeasure(JMeterMetrics.transOkPerMinute, new Double(summary.getTransOkPerMinute()));
                context.saveMeasure(JMeterMetrics.transOkPerMinuteAndUser, new Double(summary.getTransOkPerMinuteAndUser()));
                PropertiesBuilder transMapResponseTimeOkAvgPropBuild = new PropertiesBuilder(JMeterMetrics.transMapResponseTimeOkAvg, summary.getTransMapResponseTimeOkAvg());
                context.saveMeasure(new Measure(JMeterMetrics.transMapResponseTimeOkAvg, transMapResponseTimeOkAvgPropBuild.buildData()));
                PropertiesBuilder transMapResponseTimeOkDevPropBuild = new PropertiesBuilder(JMeterMetrics.transMapResponseTimeOkDevPercent, summary.getTransMapResponseTimeOkAvgDevPercent());
                context.saveMeasure(new Measure(JMeterMetrics.transMapResponseTimeOkDevPercent, transMapResponseTimeOkDevPropBuild.buildData()));
            }
        }
        catch (Exception e) {
            LOG.error("Cannot analyse project '" + project.getName() + "'", (Throwable)e);
        }
        LOG.debug("END JMeterSensor");
    }

    public JMeterReportClient getReportClient(Project project) {
        String host = (String)project.getProperty("org.sonar.plugins.jmeter.server.host");
        if (StringUtils.isBlank((String)host)) {
            throw new JMeterPluginException("You must set the HOST in sonar-jmeter-plugin config for the project '" + project.getName() + "'");
        }
        String port = (String)project.getProperty("org.sonar.plugins.jmeter.server.port");
        if (StringUtils.isBlank((String)port) || Integer.parseInt(port) == 0) {
            LOG.warn("Null or invalid jmeter-report-server PORT. Using default '{}'", (Object)4444);
            port = Integer.toString(4444);
        }
        return new JMeterReportClient(host, Integer.parseInt(port));
    }

    public String getTestConfigName(Project project) {
        String config = (String)project.getProperty("org.sonar.plugins.jmeter.server.config");
        if (StringUtils.isBlank((String)config)) {
            throw new JMeterPluginException("You must set test CONFIG in sonar-jmeter-plugin for the project '" + project.getName() + "'");
        }
        return config;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

