/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.sonar.api.internal.apachecommons.io.FileUtils;
import org.sonar.json.checks.puppet.PuppetLicenseCheck;

public class RuleDescriptionsGenerator {
    private final Map<String, String> tags = ImmutableMap.builder().put((Object)"[[allLicenses]]", (Object)this.generateHtmlTable(PuppetLicenseCheck.AVAILABLE_LICENSES)).build();

    public void generateHtmlRuleDescription(String templatePath, String outputPath) throws IOException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath), Charsets.UTF_8));
            writer.write(this.replaceTags(FileUtils.readFileToString((File)new File(templatePath), (Charset)Charsets.UTF_8)));
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not generate the HTML description.", e);
        }
    }

    private String generateHtmlTable(List<String> elements) {
        StringBuilder html = new StringBuilder("<table style=\"border: 0;\">");
        List subLists = Lists.partition(elements, (int)3);
        for (List subList : subLists) {
            html.append("<tr>");
            for (String element : subList) {
                html.append("<td style=\"border: 0;\">").append(element).append("</td>");
            }
            html.append("</tr>");
        }
        html.append("</table>");
        return html.toString();
    }

    private String replaceTags(String rawDescription) {
        String description = rawDescription;
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            description = description.replace(tag.getKey(), tag.getValue());
        }
        return description;
    }
}

