/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.generic;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.json.visitors.CharsetAwareVisitor;
import org.sonar.plugins.json.api.tree.JsonTree;
import org.sonar.plugins.json.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="bom-utf8-files", name="BOM should not be used for UTF-8 files", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class BOMCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor {
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitJson(JsonTree tree) {
        if (this.charset.equals(Charsets.UTF_8) && tree.hasByteOrderMark()) {
            this.addFileIssue("Remove the BOM.");
        }
    }
}

