/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.generic;

import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.json.checks.CheckUtils;
import org.sonar.plugins.json.api.tree.KeyTree;
import org.sonar.plugins.json.api.tree.Tree;
import org.sonar.plugins.json.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.NoSqale;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="key-regular-expression", name="Regular expression on key", priority=Priority.MAJOR)
@RuleTemplate
@NoSqale
public class KeyRegularExpressionCheck
extends DoubleDispatchVisitorCheck {
    private static final String DEFAULT_REGULAR_EXPRESSION = ".*";
    private static final String DEFAULT_MESSAGE = "The regular expression matches this key.";
    @RuleProperty(key="regularExpression", description="The regular expression. See http://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for detailed regular expression syntax.", defaultValue=".*")
    private String regularExpression = ".*";
    @RuleProperty(key="message", description="The issue message", defaultValue="The regular expression matches this key.")
    private String message = "The regular expression matches this key.";

    public void visitKey(KeyTree tree) {
        if (Pattern.compile(this.regularExpression).matcher(tree.actualText()).matches()) {
            this.addPreciseIssue((Tree)tree, this.message);
        }
        super.visitKey(tree);
    }

    public void validateParameters() {
        try {
            Pattern.compile(this.regularExpression);
        }
        catch (PatternSyntaxException exception) {
            throw new IllegalStateException(CheckUtils.paramsErrorMessage(((Object)((Object)this)).getClass(), "regularExpression parameter \"" + this.regularExpression + "\" is not a valid regular expression."), exception);
        }
    }

    @VisibleForTesting
    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    @VisibleForTesting
    public void setMessage(String message) {
        this.message = message;
    }
}

