/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.generic;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.json.api.tree.JsonTree;
import org.sonar.plugins.json.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="empty-line-end-of-file", name="Files should contain an empty new line at the end", priority=Priority.MINOR, tags={"convention"})
@SqaleConstantRemediation(value="1min")
@ActivatedByDefault
public class MissingNewLineAtEndOfFileCheck
extends DoubleDispatchVisitorCheck {
    public void visitJson(JsonTree tree) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.getContext().getFile(), "r");){
            if (!MissingNewLineAtEndOfFileCheck.endsWithNewline(randomAccessFile)) {
                this.addFileIssue("Add an empty new line at the end of this file.");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Check json:" + ((Object)((Object)this)).getClass().getAnnotation(Rule.class).key() + ": Error while reading " + this.getContext().getFile().getName(), e);
        }
    }

    private static boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < 1L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 1L);
        byte[] chars = new byte[1];
        if (randomAccessFile.read(chars) < 1) {
            return false;
        }
        String ch = new String(chars);
        return "\n".equals(ch) || "\r".equals(ch);
    }
}

