/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.puppet;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.json.checks.puppet.AbstractPuppetCheck;
import org.sonar.plugins.json.api.tree.ArrayTree;
import org.sonar.plugins.json.api.tree.ObjectTree;
import org.sonar.plugins.json.api.tree.PairTree;
import org.sonar.plugins.json.api.tree.StringTree;
import org.sonar.plugins.json.api.tree.Tree;
import org.sonar.plugins.json.api.tree.ValueTree;
import org.sonar.plugins.json.api.visitors.issue.PreciseIssue;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="puppet-duplicated-dependencies", name="Duplicated dependencies should be removed from Puppet \"metadata.json\" files", priority=Priority.MAJOR, tags={"pitfall", "puppet"})
@SqaleConstantRemediation(value="5min")
public class PuppetDuplicatedDependenciesCheck
extends AbstractPuppetCheck {
    public void visitPair(PairTree pair) {
        if ("dependencies".equals(pair.key().actualText())) {
            if (!pair.value().value().is(new Tree.Kind[]{Tree.Kind.ARRAY})) {
                this.addPreciseIssue((Tree)pair.value(), "The \"dependencies\" value is invalid. Define an array instead.");
            } else {
                this.checkDuplicatedDependencies(((ArrayTree)pair.value().value()).elements());
            }
        }
        super.visitPair(pair);
    }

    private void checkDuplicatedDependencies(List<ValueTree> dependencies) {
        Map<String, List<ValueTree>> dependenciesMap = this.buildDependenciesMap(dependencies);
        this.createIssues(dependenciesMap);
    }

    private Map<String, List<ValueTree>> buildDependenciesMap(List<ValueTree> dependencies) {
        HashMap<String, List<ValueTree>> dependenciesMap = new HashMap<String, List<ValueTree>>();
        for (ValueTree dependency : dependencies) {
            if (!dependency.value().is(new Tree.Kind[]{Tree.Kind.OBJECT})) continue;
            for (PairTree pair : ((ObjectTree)dependency.value()).pairs()) {
                if (!"name".equals(pair.key().actualText()) || !pair.value().value().is(new Tree.Kind[]{Tree.Kind.STRING})) continue;
                String actualValue = ((StringTree)pair.value().value()).actualText();
                if (dependenciesMap.containsKey(actualValue)) {
                    ((List)dependenciesMap.get(actualValue)).add(pair.value());
                    continue;
                }
                dependenciesMap.put(actualValue, Lists.newArrayList((Object[])new ValueTree[]{pair.value()}));
            }
        }
        return dependenciesMap;
    }

    private void createIssues(Map<String, List<ValueTree>> dependenciesMap) {
        for (Map.Entry<String, List<ValueTree>> entry : dependenciesMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            PreciseIssue issue = this.addPreciseIssue((Tree)entry.getValue().get(0), "Merge those duplicated \"" + entry.getKey() + "\" dependencies.");
            for (int i = 1; i < entry.getValue().size(); ++i) {
                issue.secondary((Tree)entry.getValue().get(i), "Duplicated dependency");
            }
        }
    }
}

