/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.puppet;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.json.checks.puppet.AbstractPuppetCheck;
import org.sonar.plugins.json.api.tree.PairTree;
import org.sonar.plugins.json.api.tree.StringTree;
import org.sonar.plugins.json.api.tree.Tree;
import org.sonar.plugins.json.api.tree.ValueTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="puppet-enforce-author-value", name="\"author\" should match the required value in Puppet \"metadata.json\" files", priority=Priority.MAJOR, tags={"convention", "puppet"})
@SqaleConstantRemediation(value="5min")
public class PuppetEnforceAuthorValueCheck
extends AbstractPuppetCheck {
    private static final String DEFAULT_AUTHOR = "John Doe";
    @RuleProperty(key="value", defaultValue="John Doe", description="Author to be set")
    private String author = "John Doe";

    public void visitPair(PairTree pair) {
        if ("author".equals(pair.key().actualText())) {
            if (!pair.value().value().is(new Tree.Kind[]{Tree.Kind.STRING})) {
                this.createIssue(pair.value());
            } else if (!this.author.equals(((StringTree)pair.value().value()).actualText())) {
                this.createIssue(pair.value());
            }
        }
        super.visitPair(pair);
    }

    @VisibleForTesting
    public void setAuthor(String author) {
        this.author = author;
    }

    private void createIssue(ValueTree tree) {
        this.addPreciseIssue((Tree)tree, "Set the author to \"" + this.author + "\".");
    }
}

