/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.puppet;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.json.checks.puppet.AbstractPuppetCheck;
import org.sonar.plugins.json.api.tree.PairTree;
import org.sonar.plugins.json.api.tree.StringTree;
import org.sonar.plugins.json.api.tree.Tree;
import org.sonar.plugins.json.api.tree.ValueTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="puppet-enforce-license-value", name="\"license\" should match the required value in Puppet \"metadata.json\" files", priority=Priority.MAJOR, tags={"convention", "puppet"})
@SqaleConstantRemediation(value="5min")
public class PuppetEnforceLicenseValueCheck
extends AbstractPuppetCheck {
    private static final String DEFAULT_LICENSE = "LGPL-3.0";
    @RuleProperty(key="value", defaultValue="LGPL-3.0", description="License to be set")
    private String license = "LGPL-3.0";

    public void visitPair(PairTree pair) {
        if ("license".equals(pair.key().actualText())) {
            if (!pair.value().value().is(new Tree.Kind[]{Tree.Kind.STRING})) {
                this.createIssue(pair.value());
            } else if (!this.license.equals(((StringTree)pair.value().value()).actualText())) {
                this.createIssue(pair.value());
            }
        }
        super.visitPair(pair);
    }

    @VisibleForTesting
    public void setLicense(String license) {
        this.license = license;
    }

    private void createIssue(ValueTree tree) {
        this.addPreciseIssue((Tree)tree, "Set the license to \"" + this.license + "\".");
    }
}

