/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.puppet;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.json.api.tree.JsonTree;
import org.sonar.plugins.json.api.tree.KeyTree;
import org.sonar.plugins.json.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="puppet-required-keys", name="Puppet \"metadata.json\" files should define all the required keys", priority=Priority.MAJOR, tags={"convention", "puppet"})
@SqaleConstantRemediation(value="10min")
public class PuppetRequiredKeysCheck
extends DoubleDispatchVisitorCheck {
    private static final List<String> REQUIRED_KEYS = ImmutableList.of((Object)"name", (Object)"version", (Object)"author", (Object)"license", (Object)"summary", (Object)"source", (Object)"dependencies");
    private final List<String> definedKeys = new ArrayList<String>();
    private final List<String> missingKeys = new ArrayList<String>();

    public void visitJson(JsonTree tree) {
        this.definedKeys.clear();
        this.missingKeys.clear();
        if ("metadata.json".equals(this.getContext().getFile().getName())) {
            super.visitJson(tree);
            for (String requiredKey : REQUIRED_KEYS) {
                if (this.definedKeys.contains(requiredKey)) continue;
                this.missingKeys.add(requiredKey);
            }
            if (!this.missingKeys.isEmpty()) {
                this.addFileIssue("Add the following keys that are required: " + Joiner.on((String)", ").join(this.missingKeys) + ".");
            }
        }
    }

    public void visitKey(KeyTree key) {
        this.definedKeys.add(key.actualText());
        super.visitKey(key);
    }
}

