/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.puppet;

import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.json.checks.puppet.AbstractPuppetCheck;
import org.sonar.plugins.json.api.tree.PairTree;
import org.sonar.plugins.json.api.tree.StringTree;
import org.sonar.plugins.json.api.tree.Tree;
import org.sonar.plugins.json.api.tree.ValueTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="puppet-version", name="\"version\" should be a semantic version in Puppet \"metadata.json\" files", priority=Priority.MAJOR, tags={"convention", "puppet"})
@SqaleConstantRemediation(value="5min")
public class PuppetVersionCheck
extends AbstractPuppetCheck {
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+$");

    public void visitPair(PairTree pair) {
        if ("version".equals(pair.key().actualText())) {
            if (!pair.value().value().is(new Tree.Kind[]{Tree.Kind.STRING})) {
                this.createIssue(pair.value());
            } else if (!SEMANTIC_VERSION_PATTERN.matcher(((StringTree)pair.value().value()).actualText()).matches()) {
                this.createIssue(pair.value());
            }
        }
        super.visitPair(pair);
    }

    private void createIssue(ValueTree tree) {
        this.addPreciseIssue((Tree)tree, "Define the version as a semantic version on 3 digits separated by dots: ^\\d+\\.\\d+\\.\\d+$");
    }
}

