/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.generic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.json.checks.CheckUtils;
import org.sonar.plugins.json.api.tree.Tree;
import org.sonar.plugins.json.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1578", name="File names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class FileNameCheck
extends SubscriptionVisitorCheck {
    public static final String DEFAULT = "^[A-Za-z][-_A-Za-z0-9]*\\.json$";
    @RuleProperty(key="format", defaultValue="^[A-Za-z][-_A-Za-z0-9]*\\.json$", description="Regular expression that file names should match. See http://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for detailed regular expression syntax.")
    private String format = "^[A-Za-z][-_A-Za-z0-9]*\\.json$";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.JSON);
    }

    public void visitFile(Tree tree) {
        if (!Pattern.compile(this.format).matcher(this.getContext().getFile().getName()).matches()) {
            this.addFileIssue("Rename this file to match this regular expression: " + this.format);
        }
    }

    public void validateParameters() {
        try {
            Pattern.compile(this.format);
        }
        catch (PatternSyntaxException exception) {
            throw new IllegalStateException(CheckUtils.paramsErrorMessage(((Object)((Object)this)).getClass(), "format parameter \"" + this.format + "\" is not a valid regular expression."), exception);
        }
    }

    @VisibleForTesting
    public void setFormat(String format) {
        this.format = format;
    }
}

