/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.generic;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.json.visitors.CharsetAwareVisitor;
import org.sonar.plugins.json.api.tree.JsonTree;
import org.sonar.plugins.json.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="tab-character", name="Tabulation characters should not be used", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleConstantRemediation(value="2min")
public class TabCharacterCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor {
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitJson(JsonTree tree) {
        List lines;
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Check json:" + ((Object)((Object)this)).getClass().getAnnotation(Rule.class).key() + ": Error while reading " + this.getContext().getFile().getName(), e);
        }
        for (String line : lines) {
            if (!line.contains("\t")) continue;
            this.addFileIssue("Replace all tab characters in this file by sequences of whitespaces.");
            break;
        }
        super.visitJson(tree);
    }
}

