/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.json.checks.puppet;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.json.checks.puppet.AbstractPuppetCheck;
import org.sonar.plugins.json.api.tree.KeyTree;
import org.sonar.plugins.json.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="puppet-deprecated-keys", name="Deprecated keys should be removed from Puppet \"metadata.json\" files", priority=Priority.MAJOR, tags={"obsolete", "puppet"})
@SqaleConstantRemediation(value="5min")
public class PuppetDeprecatedKeysCheck
extends AbstractPuppetCheck {
    public void visitKey(KeyTree tree) {
        if ("types".equals(tree.actualText())) {
            this.addPreciseIssue((Tree)tree, "Remove this deprecated \"types\" key.");
        } else if ("checksums".equals(tree.actualText())) {
            this.addPreciseIssue((Tree)tree, "Remove this deprecated \"checksums\" key.");
        } else if ("description".equals(tree.actualText())) {
            this.addPreciseIssue((Tree)tree, "Replace this deprecated \"description\" key by the \"summary\" key.");
        }
        super.visitKey(tree);
    }
}

