/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cobertura;

import com.google.common.collect.Maps;
import java.io.File;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.api.utils.XmlParserException;

public class CoberturaReportParserUtils {
    private CoberturaReportParserUtils() {
    }

    public static void parseReport(File xmlFile, final SensorContext context, final FileResolver fileResolver) {
        try {
            StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

                public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                    rootCursor.advance();
                    CoberturaReportParserUtils.collectPackageMeasures(rootCursor.descendantElementCursor("package"), context, fileResolver);
                }
            });
            parser.parse(xmlFile);
        }
        catch (XMLStreamException e) {
            throw new XmlParserException((Throwable)e);
        }
    }

    private static void collectPackageMeasures(SMInputCursor pack, SensorContext context, FileResolver fileResolver) throws XMLStreamException {
        while (pack.getNext() != null) {
            HashMap builderByFilename = Maps.newHashMap();
            CoberturaReportParserUtils.collectFileMeasures(pack.descendantElementCursor("class"), builderByFilename);
            for (Map.Entry entry : builderByFilename.entrySet()) {
                String filename = CoberturaReportParserUtils.sanitizeFilename((String)entry.getKey());
                Resource<?> file = fileResolver.resolve(filename);
                if (!CoberturaReportParserUtils.fileExists(context, file)) continue;
                for (Measure measure : ((CoverageMeasuresBuilder)entry.getValue()).createMeasures()) {
                    context.saveMeasure(file, measure);
                }
            }
        }
    }

    private static boolean fileExists(SensorContext context, Resource<?> file) {
        return context.getResource(file) != null;
    }

    private static void collectFileMeasures(SMInputCursor clazz, Map<String, CoverageMeasuresBuilder> builderByFilename) throws XMLStreamException {
        while (clazz.getNext() != null) {
            String fileName = clazz.getAttrValue("filename");
            CoverageMeasuresBuilder builder = builderByFilename.get(fileName);
            if (builder == null) {
                builder = CoverageMeasuresBuilder.create();
                builderByFilename.put(fileName, builder);
            }
            CoberturaReportParserUtils.collectFileData(clazz, builder);
        }
    }

    private static void collectFileData(SMInputCursor clazz, CoverageMeasuresBuilder builder) throws XMLStreamException {
        SMInputCursor line = clazz.childElementCursor("lines").advance().childElementCursor("line");
        while (line.getNext() != null) {
            int lineId = Integer.parseInt(line.getAttrValue("number"));
            try {
                builder.setHits(lineId, (int)ParsingUtils.parseNumber((String)line.getAttrValue("hits"), (Locale)Locale.ENGLISH));
            }
            catch (ParseException e) {
                throw new XmlParserException((Throwable)e);
            }
            String isBranch = line.getAttrValue("branch");
            String text = line.getAttrValue("condition-coverage");
            if (!StringUtils.equals((String)isBranch, (String)"true") || !StringUtils.isNotBlank((String)text)) continue;
            String[] conditions = StringUtils.split((String)StringUtils.substringBetween((String)text, (String)"(", (String)")"), (String)"/");
            builder.setConditions(lineId, Integer.parseInt(conditions[1]), Integer.parseInt(conditions[0]));
        }
    }

    private static String sanitizeFilename(String s) {
        String fileName = FilenameUtils.removeExtension((String)s);
        fileName = fileName.replace('/', '.').replace('\\', '.');
        return fileName;
    }

    public static interface FileResolver {
        public Resource<?> resolve(String var1);
    }
}

