/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cobertura;

import java.io.File;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.plugins.cobertura.CoberturaReportParserUtils;
import org.sonar.plugins.cobertura.CoberturaSettings;

public class CoberturaSensor
implements Sensor,
CoverageExtension {
    private CoberturaSettings coberturaSettings;
    private ModuleFileSystem fileSystem;
    private PathResolver pathResolver;
    private Settings settings;

    public CoberturaSensor(CoberturaSettings coberturaSettings, ModuleFileSystem fileSystem, PathResolver pathResolver, Settings settings) {
        this.coberturaSettings = coberturaSettings;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.coberturaSettings.isEnabled(project);
    }

    public void analyse(Project project, SensorContext context) {
        String path = this.settings.getString("sonar.cobertura.reportPath");
        if (path == null) {
            return;
        }
        File report = this.pathResolver.relativeFile(this.fileSystem.baseDir(), path);
        if (!report.exists() || !report.isFile()) {
            LoggerFactory.getLogger(this.getClass()).warn("Cobertura report not found at {}", (Object)report);
            return;
        }
        this.parseReport(report, context);
    }

    protected void parseReport(File xmlFile, SensorContext context) {
        LoggerFactory.getLogger(CoberturaSensor.class).info("parsing {}", (Object)xmlFile);
        CoberturaReportParserUtils.parseReport(xmlFile, context, new CoberturaReportParserUtils.FileResolver(){

            @Override
            public Resource<?> resolve(String filename) {
                return new JavaFile(filename);
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

