/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.base;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import org.codehaus.staxmate.SMInputFactory;

public final class FortifyUtils {
    private static final double BLOCKER_SEVERITY_THRESHOLD = 4.0;
    private static final double CRITICAL_SEVERITY_THRESHOLD = 3.0;
    private static final double MAJOR_SEVERITY_THRESHOLD = 2.0;
    private static final double MINOR_SEVERITY_THRESHOLD = 1.0;

    private FortifyUtils() {
    }

    public static SMInputFactory newStaxParser() throws FactoryConfigurationError {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    public static String fortifyToSonarQubeSeverity(String fortifySeverity) {
        Double level = Double.valueOf(fortifySeverity);
        String severity = level >= 4.0 ? "BLOCKER" : (level >= 3.0 ? "CRITICAL" : (level >= 2.0 ? "MAJOR" : (level >= 1.0 ? "MINOR" : "INFO")));
        return severity;
    }
}

