/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.fvdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.utils.MessageException;
import org.sonar.fortify.fvdl.FortifySensorConfiguration;

class FortifyReportFile {
    private final FortifySensorConfiguration configuration;
    private final FileSystem fileSystem;

    FortifyReportFile(FortifySensorConfiguration configuration, FileSystem fileSystem) {
        this.configuration = configuration;
        this.fileSystem = fileSystem;
    }

    @CheckForNull
    private File getReportFromProperty() {
        String path = this.configuration.getReportPath();
        if (StringUtils.isNotBlank((String)path)) {
            File report = new File(path);
            if (!report.isAbsolute()) {
                report = new File(this.fileSystem.baseDir(), path);
            }
            if (report.exists() && report.isFile()) {
                return report;
            }
            throw MessageException.of((String)("Fortify report does not exist. Please check property sonar.fortify.reportPath: " + path));
        }
        return null;
    }

    private InputStream getInputStreamFromFprFile(File file) throws IOException {
        final ZipFile fprFile = new ZipFile(file);
        try {
            final InputStream reportStream = fprFile.getInputStream(fprFile.getEntry("audit.fvdl"));
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return reportStream.read();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        reportStream.close();
                    }
                    finally {
                        fprFile.close();
                    }
                }
            };
        }
        catch (IOException e) {
            fprFile.close();
            throw e;
        }
    }

    private InputStream getInputStreamFromFVDLFile(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    InputStream getInputStream() throws IOException {
        File file = this.getReportFromProperty();
        if (file == null) {
            throw new FileNotFoundException();
        }
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        if ("fpr".equalsIgnoreCase(fileExtension)) {
            return this.getInputStreamFromFprFile(file);
        }
        return this.getInputStreamFromFVDLFile(file);
    }

    boolean exist() {
        File report = this.getReportFromProperty();
        return report != null;
    }
}

