/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.fvdl;

import java.io.File;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.fortify.base.FortifyConstants;
import org.sonar.fortify.base.FortifyMetrics;
import org.sonar.fortify.fvdl.FortifyReportFile;
import org.sonar.fortify.fvdl.FortifySensorConfiguration;
import org.sonar.fortify.fvdl.FvdlStAXParser;
import org.sonar.fortify.fvdl.element.Fvdl;
import org.sonar.fortify.fvdl.element.Vulnerability;

public class FortifySensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(FortifySensor.class);
    private static final double BLOCKER_SECURITY_RATING_LEVEL = 1.0;
    private static final double CRITICAL_SECURITY_RATING_LEVEL = 2.0;
    private static final double MAJOR_SECURITY_RATING_LEVEL = 3.0;
    private static final double MINOR_SECURITY_RATING_LEVEL = 4.0;
    private static final double DEFAULT_SECURITY_RATING_LEVEL = 5.0;
    private final FortifySensorConfiguration configuration;
    private final ResourcePerspectives resourcePerspectives;
    private final FileSystem fileSystem;
    private final ActiveRules activeRules;
    private final FortifyReportFile report;
    private int blockerIssuesCount = 0;
    private int criticalIssuesCount = 0;
    private int majorIssuesCount = 0;
    private int minorIssuesCount = 0;

    public FortifySensor(FortifySensorConfiguration configuration, ResourcePerspectives resourcePerspectives, FileSystem fileSystem, ActiveRules activeRules) {
        this.configuration = configuration;
        this.resourcePerspectives = resourcePerspectives;
        this.fileSystem = fileSystem;
        this.activeRules = activeRules;
        this.report = new FortifyReportFile(configuration, fileSystem);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.configuration.isActive(this.fileSystem.languages()) && this.report.exist();
    }

    private void addIssue(Resource resource, Fvdl fvdl, Vulnerability vulnerability, ActiveRule activeRule) {
        Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, resource);
        if (issuable != null) {
            Issue issue;
            String severity = vulnerability.getInstanceSeverity();
            if (severity == null) {
                severity = activeRule.severity();
            }
            if (issuable.addIssue(issue = issuable.newIssueBuilder().ruleKey(activeRule.ruleKey()).line(vulnerability.getLine()).message(fvdl.getDescription(vulnerability)).severity(severity).build())) {
                this.incrementCount(severity);
            }
        }
    }

    private void incrementCount(String severity) {
        if ("BLOCKER".equals(severity)) {
            ++this.blockerIssuesCount;
        } else if ("CRITICAL".equals(severity)) {
            ++this.criticalIssuesCount;
        } else if ("MAJOR".equals(severity)) {
            ++this.majorIssuesCount;
        } else if ("MINOR".equals(severity)) {
            ++this.minorIssuesCount;
        }
    }

    private void addIssues(SensorContext context, Project project, Fvdl fvdl) {
        String sourceBasePath = fvdl.getBuild().getSourceBasePath();
        for (Vulnerability vulnerability : fvdl.getVulnerabilities()) {
            Resource resource = this.resourceOf(context, sourceBasePath, vulnerability, project);
            if (resource == null) continue;
            ActiveRule activeRule = this.getRule(vulnerability);
            if (activeRule == null) {
                LOG.debug("Fortify rule '{}' is not active in quality profiles of your project.", (Object)vulnerability.getClassID());
                continue;
            }
            this.addIssue(resource, fvdl, vulnerability, activeRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse(Project project, SensorContext context) {
        TimeProfiler profiler = new TimeProfiler().start("Process Fortify report");
        try {
            InputStream stream = this.report.getInputStream();
            try {
                Fvdl fvdl = new FvdlStAXParser().parse(stream);
                this.addIssues(context, project, fvdl);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new SonarException("Can not process Fortify report", (Throwable)e);
        }
        finally {
            profiler.stop();
        }
        this.saveMeasures(context);
    }

    private void saveMeasures(SensorContext context) {
        context.saveMeasure(FortifyMetrics.CFPO, Double.valueOf(this.blockerIssuesCount));
        context.saveMeasure(FortifyMetrics.HFPO, Double.valueOf(this.criticalIssuesCount));
        context.saveMeasure(FortifyMetrics.MFPO, Double.valueOf(this.majorIssuesCount));
        context.saveMeasure(FortifyMetrics.LFPO, Double.valueOf(this.minorIssuesCount));
        if (this.blockerIssuesCount > 0) {
            context.saveMeasure(FortifyMetrics.SECURITY_RATING, Double.valueOf(1.0));
        } else if (this.criticalIssuesCount > 0) {
            context.saveMeasure(FortifyMetrics.SECURITY_RATING, Double.valueOf(2.0));
        } else if (this.majorIssuesCount > 0) {
            context.saveMeasure(FortifyMetrics.SECURITY_RATING, Double.valueOf(3.0));
        } else if (this.minorIssuesCount > 0) {
            context.saveMeasure(FortifyMetrics.SECURITY_RATING, Double.valueOf(4.0));
        } else {
            context.saveMeasure(FortifyMetrics.SECURITY_RATING, Double.valueOf(5.0));
        }
    }

    @CheckForNull
    private ActiveRule getRule(Vulnerability vulnerability) {
        ActiveRule rule = null;
        for (String language : this.fileSystem.languages()) {
            String repositoryKey = FortifyConstants.fortifyRepositoryKey(language);
            rule = this.activeRules.find(RuleKey.of((String)repositoryKey, (String)vulnerability.getClassID()));
            if (rule == null) continue;
            return rule;
        }
        return rule;
    }

    @CheckForNull
    private Resource resourceOf(SensorContext context, String sourceBasePath, Vulnerability vulnerability, Project project) {
        File file = new File(sourceBasePath, vulnerability.getPath());
        if (file.exists()) {
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
            if (resource == null || context.getResource((Resource)resource) == null) {
                LOG.debug("File \"{}\" is not under module basedir or is not indexed. Skip it.", (Object)vulnerability.getPath());
                return null;
            }
            return resource;
        }
        LOG.debug("Unable to find \"{}\". Trying relative path.", (Object)file);
        file = new File(this.fileSystem.baseDir(), vulnerability.getPath());
        if (file.exists()) {
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
            if (resource == null || context.getResource((Resource)resource) == null) {
                LOG.debug("File \"{}\" is not indexed. Skip it.", (Object)vulnerability.getPath());
                return null;
            }
            return resource;
        }
        LOG.debug("Unable to find \"{}\". Your Fortify analysis was probably started from a different location than current SonarQube analysis.", (Object)file);
        return null;
    }

    public String toString() {
        return "Fortify sensor";
    }
}

