/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.fvdl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.fortify.base.FortifyUtils;
import org.sonar.fortify.fvdl.element.Build;
import org.sonar.fortify.fvdl.element.Description;
import org.sonar.fortify.fvdl.element.Fvdl;
import org.sonar.fortify.fvdl.element.ReplacementDefinition;
import org.sonar.fortify.fvdl.element.Vulnerability;
import org.xml.sax.SAXException;

public class FvdlStAXParser {
    Fvdl parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SMInputFactory inputFactory = FortifyUtils.newStaxParser();
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(inputStream);
            rootC.advance();
            SMInputCursor childCursor = rootC.childCursor();
            Build build = null;
            ArrayList<Description> descriptions = new ArrayList<Description>();
            Collection<Vulnerability> vulnerabilities = null;
            while (childCursor.getNext() != null) {
                String nodeName = childCursor.getLocalName();
                if ("Build".equals(nodeName)) {
                    build = this.processBuild(childCursor);
                    continue;
                }
                if ("Description".equals(nodeName)) {
                    descriptions.add(this.processDescription(childCursor));
                    continue;
                }
                if (!"Vulnerabilities".equals(nodeName)) continue;
                vulnerabilities = this.processVulnerabilities(childCursor);
            }
            return new Fvdl(build, descriptions, vulnerabilities);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private Collection<Vulnerability> processVulnerabilities(SMInputCursor vulnsC) throws XMLStreamException {
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        SMInputCursor vulnCursor = vulnsC.childElementCursor("Vulnerability");
        while (vulnCursor.getNext() != null) {
            vulnerabilities.add(this.processVulnerability(vulnCursor));
        }
        return vulnerabilities;
    }

    private Vulnerability processVulnerability(SMInputCursor vulnCursor) throws XMLStreamException {
        Vulnerability vulnerability = new Vulnerability();
        SMInputCursor childCursor = vulnCursor.childCursor();
        while (childCursor.getNext() != null) {
            String nodeName = childCursor.getLocalName();
            if ("ClassInfo".equals(nodeName)) {
                this.processClassInfo(childCursor, vulnerability);
                continue;
            }
            if ("InstanceInfo".equals(nodeName)) {
                this.processInstanceInfo(childCursor, vulnerability);
                continue;
            }
            if (!"AnalysisInfo".equals(nodeName)) continue;
            this.processAnalysisInfo(childCursor, vulnerability);
        }
        return vulnerability;
    }

    private void processAnalysisInfo(SMInputCursor paCursor, Vulnerability vulnerability) throws XMLStreamException {
        SMInputCursor unifiedCursor = paCursor.childElementCursor("Unified");
        if (unifiedCursor.getNext() != null) {
            SMInputCursor childCursor = unifiedCursor.childCursor();
            while (childCursor.getNext() != null) {
                String nodeName = childCursor.getLocalName();
                if ("Trace".equals(nodeName)) {
                    this.processTrace(childCursor, vulnerability);
                    continue;
                }
                if (!"ReplacementDefinitions".equals(nodeName)) continue;
                this.processReplacementDefinitions(childCursor, vulnerability);
            }
        }
    }

    private void processReplacementDefinitions(SMInputCursor repDefsCursor, Vulnerability vulnerability) throws XMLStreamException {
        SMInputCursor repDefCursor = repDefsCursor.childElementCursor("Def");
        while (repDefCursor.getNext() != null) {
            vulnerability.addReplacementDefinition(new ReplacementDefinition(repDefCursor.getAttrValue("key"), repDefCursor.getAttrValue("value")));
        }
    }

    private void processTrace(SMInputCursor traceCursor, Vulnerability vulnerability) throws XMLStreamException {
        SMInputCursor primaryCursor = traceCursor.childElementCursor("Primary");
        if (primaryCursor.getNext() != null) {
            SMInputCursor entryCursor = primaryCursor.childElementCursor("Entry");
            while (entryCursor.getNext() != null) {
                this.processNode(vulnerability, entryCursor);
            }
        }
    }

    private void processNode(Vulnerability vulnerability, SMInputCursor entryCursor) throws XMLStreamException {
        SMInputCursor sourceLocationCursor;
        SMInputCursor nodeCursor = entryCursor.childElementCursor("Node");
        if (nodeCursor.getNext() != null && "true".equals(nodeCursor.getAttrValue("isDefault")) && (sourceLocationCursor = nodeCursor.childElementCursor("SourceLocation")).getNext() != null) {
            vulnerability.setPath(sourceLocationCursor.getAttrValue("path"));
            vulnerability.setLine(Integer.valueOf(sourceLocationCursor.getAttrValue("line")));
        }
    }

    private void processInstanceInfo(SMInputCursor instanceInfoCursor, Vulnerability vulnerability) throws XMLStreamException {
        SMInputCursor childCursor = instanceInfoCursor.childCursor();
        while (childCursor.getNext() != null) {
            String nodeName = childCursor.getLocalName();
            if ("InstanceID".equals(nodeName)) {
                vulnerability.setInstanceID(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if (!"InstanceSeverity".equals(nodeName)) continue;
            vulnerability.setInstanceSeverity(FortifyUtils.fortifyToSonarQubeSeverity(StringUtils.trim((String)childCursor.collectDescendantText(false))));
        }
    }

    private void processClassInfo(SMInputCursor classInfoCursor, Vulnerability vulnerability) throws XMLStreamException {
        SMInputCursor classIDCursor = classInfoCursor.childElementCursor("ClassID");
        if (classIDCursor.getNext() != null) {
            vulnerability.setClassID(StringUtils.trim((String)classIDCursor.collectDescendantText(false)));
        }
    }

    private Description processDescription(SMInputCursor descC) throws XMLStreamException {
        Description description = new Description();
        description.setClassID(descC.getAttrValue("classID"));
        SMInputCursor abstractCursor = descC.childElementCursor("Abstract");
        if (abstractCursor.getNext() != null) {
            description.setAbstract(StringUtils.trim((String)abstractCursor.collectDescendantText(false)));
        }
        return description;
    }

    private Build processBuild(SMInputCursor buildC) throws XMLStreamException {
        SMInputCursor childCursor = buildC.childCursor();
        while (childCursor.getNext() != null) {
            String nodeName = childCursor.getLocalName();
            if (!StringUtils.equalsIgnoreCase((String)"SourceBasePath", (String)nodeName)) continue;
            String sourceBasePath = StringUtils.trim((String)childCursor.collectDescendantText(false));
            return new Build(sourceBasePath);
        }
        return null;
    }
}

