/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.fortify.base.FortifyConstants;
import org.sonar.fortify.rule.RulePackParser;
import org.sonar.fortify.rule.element.FormatVersion;
import org.sonar.fortify.rule.element.FortifyRule;
import org.sonar.fortify.rule.element.RulePack;

public final class FortifyRulesDefinition
implements RulesDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(FortifyRulesDefinition.class);
    private static final Map<String, String> FORTIFY_TO_SQ = ImmutableMap.builder().put((Object)"actionscript", (Object)"flex").put((Object)"javascript", (Object)"js").put((Object)"dotnet", (Object)"cs").put((Object)"configuration", (Object)"xml").put((Object)"content", (Object)"web").put((Object)"jsp", (Object)"web").put((Object)"python", (Object)"py").build();
    private final Languages languages;
    private final RulePackParser rulePackParser;
    private final Map<String, RulesDefinition.NewRepository> newRepositories = new HashMap<String, RulesDefinition.NewRepository>();
    private final Map<String, FormatVersion> addedRulesVersions = new HashMap<String, FormatVersion>();
    private final Map<String, Map<String, Set<String>>> addedRuleIdsByLanguageAndName = new HashMap<String, Map<String, Set<String>>>();

    public FortifyRulesDefinition(Settings settings, Languages languages) {
        this(new RulePackParser(settings), languages);
    }

    @VisibleForTesting
    FortifyRulesDefinition(RulePackParser rulePackParser, Languages languages) {
        this.rulePackParser = rulePackParser;
        this.languages = languages;
    }

    public void define(RulesDefinition.Context context) {
        List<RulePack> rulePacks = this.rulePackParser.parse();
        for (RulesDefinition.NewRepository newRepository : this.parseRulePacks(context, rulePacks)) {
            newRepository.done();
        }
    }

    private Collection<RulesDefinition.NewRepository> parseRulePacks(RulesDefinition.Context context, List<RulePack> rulePacks) {
        for (RulePack rulePack : rulePacks) {
            for (FortifyRule rule : rulePack.getRules()) {
                String sqLanguageKey = this.convertToSQ(rulePack.getRuleLanguage(rule));
                if (this.languages.get(sqLanguageKey) == null || !this.isAnInterestingRule(rule)) continue;
                this.processRule(context, rulePack, rule, sqLanguageKey);
            }
        }
        return this.newRepositories.values();
    }

    private void processRule(RulesDefinition.Context context, RulePack rulePack, FortifyRule rule, String sqLanguageKey) {
        Set<String> ruleIds;
        RulesDefinition.NewRepository repo = this.getRepository(context, sqLanguageKey);
        String htmlDescription = rulePack.getHTMLDescription(rule.getDescription());
        RulesDefinition.NewRule newRule = repo.rule(rule.getRuleID());
        if (newRule == null) {
            newRule = repo.createRule(rule.getRuleID());
        }
        String name = rule.getName();
        Map<String, Set<String>> addedRuleIdsByName = this.addedRuleIdsByLanguageAndName.get(sqLanguageKey);
        if (addedRuleIdsByName == null) {
            addedRuleIdsByName = new HashMap<String, Set<String>>();
            this.addedRuleIdsByLanguageAndName.put(sqLanguageKey, addedRuleIdsByName);
        }
        if ((ruleIds = addedRuleIdsByName.get(name)) == null) {
            ruleIds = new HashSet<String>();
            ruleIds.add(rule.getRuleID());
            addedRuleIdsByName.put(name, ruleIds);
            newRule.setName(name);
        } else {
            if (ruleIds.size() == 1) {
                RulesDefinition.NewRule alreadyAdded = repo.rule(ruleIds.iterator().next());
                alreadyAdded.setName(name + " - #1");
            }
            ruleIds.add(rule.getRuleID());
            newRule.setName(name + " - #" + ruleIds.size());
        }
        newRule.setHtmlDescription(StringUtils.isNotBlank((String)htmlDescription) ? htmlDescription : "No description available").setSeverity(rule.getDefaultSeverity()).setTags(rule.getTags());
        this.addedRulesVersions.put(rule.getRuleID(), rule.getFormatVersion());
    }

    private boolean isAnInterestingRule(FortifyRule rule) {
        boolean isInteresting;
        FormatVersion previousVersion = this.addedRulesVersions.get(rule.getRuleID());
        if (previousVersion == null) {
            isInteresting = true;
        } else if (previousVersion.compareTo(rule.getFormatVersion()) > 0) {
            LOG.debug("The rule {} was already added in formatVersion {}, ignoring one with formatVersion {}.", new Object[]{rule.getRuleID(), previousVersion, rule.getFormatVersion()});
            isInteresting = false;
        } else if (previousVersion.compareTo(rule.getFormatVersion()) == 0) {
            LOG.debug("The rule {} was already added in formatVersion {}.", (Object)rule.getRuleID(), (Object)previousVersion);
            isInteresting = false;
        } else {
            LOG.debug("The rule {} was already added in formatVersion {}, replace it by the one with formatVersion {}.", new Object[]{rule.getRuleID(), previousVersion, rule.getFormatVersion()});
            isInteresting = true;
        }
        return isInteresting;
    }

    private RulesDefinition.NewRepository getRepository(RulesDefinition.Context context, String sqLanguageKey) {
        String repoKey = FortifyConstants.fortifyRepositoryKey(sqLanguageKey);
        if (!this.newRepositories.containsKey(repoKey)) {
            this.newRepositories.put(repoKey, context.createRepository(repoKey, sqLanguageKey).setName("Fortify"));
        }
        return this.newRepositories.get(repoKey);
    }

    private String convertToSQ(String ruleLanguage) {
        if (FORTIFY_TO_SQ.containsKey(ruleLanguage)) {
            return FORTIFY_TO_SQ.get(ruleLanguage);
        }
        return ruleLanguage;
    }
}

