/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.rule;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.fortify.rule.RulePackStAXParser;
import org.sonar.fortify.rule.element.RulePack;

public class RulePackParser {
    private static final Logger LOG = LoggerFactory.getLogger(RulePackParser.class);
    private final Settings settings;

    public RulePackParser(Settings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RulePack> parse() {
        ArrayList<File> files = new ArrayList<File>();
        for (String location : this.settings.getStringArray("sonar.fortify.rulepackPaths")) {
            File file = new File(location);
            if (file.isDirectory()) {
                files.addAll(FileUtils.listFiles((File)file, (String[])new String[]{"xml"}, (boolean)false));
                continue;
            }
            if (file.exists()) {
                files.add(file);
                continue;
            }
            LOG.warn("Ignore rulepack location: \"{}\", file is not found.", (Object)file);
        }
        ArrayList<RulePack> rulePacks = new ArrayList<RulePack>();
        for (File file : files) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                rulePacks.add(new RulePackStAXParser().parse(stream));
            }
            catch (Exception e) {
                try {
                    LOG.error("Unexpected error during the parse of " + file + ".", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(stream);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)stream);
                continue;
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        return rulePacks;
    }
}

