/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.rule;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.fortify.base.FortifyUtils;
import org.sonar.fortify.rule.element.Description;
import org.sonar.fortify.rule.element.FortifyRule;
import org.sonar.fortify.rule.element.Reference;
import org.sonar.fortify.rule.element.RulePack;
import org.xml.sax.SAXException;

public class RulePackStAXParser {
    private static final Logger LOG = LoggerFactory.getLogger(RulePackStAXParser.class);
    private static final Collection<String> INTERNAL_RULE_NAMES = Sets.newHashSet((Object[])new String[]{"AliasRule", "AllocationRule", "BufferCopyRule", "CharacterizationRule", "ControlflowActionPrototype", "ControlflowTransition", "CustomDescriptionRule", "GlobalClassRule", "MapRule", "NonReturningRule", "ResultFilterRule", "ScriptedCallGraphRule", "StringLengthRule", "SuppressionRule", "DataflowCleanseRule", "DataflowEntryPointRule", "DataflowPassthroughRule", "DataflowSourceRule", "DeprecationRule", "GlobalFieldRule", "StatisticalRule", "InputSetRule"});
    private static final Collection<String> REAL_RULE_NAMES = Sets.newHashSet((Object[])new String[]{"ConfigurationRule", "ContentRule", "ControlflowRule", "DataflowSinkRule", "SemanticRule", "StructuralRule", "InternalRule"});

    RulePack parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SMInputFactory inputFactory = FortifyUtils.newStaxParser();
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(inputStream);
            rootC.advance();
            SMInputCursor childCursor = rootC.childCursor();
            RulePack rulePack = new RulePack();
            while (childCursor.getNext() != null) {
                String nodeName = childCursor.getLocalName();
                if ("Name".equals(nodeName)) {
                    rulePack.setName(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                    continue;
                }
                if ("Language".equals(nodeName)) {
                    rulePack.setLanguage(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                    continue;
                }
                if (!"Rules".equals(nodeName)) continue;
                this.processRules(childCursor, rulePack);
            }
            LOG.debug(rulePack.name() + " - " + rulePack.language() + " - " + rulePack.getRules().size());
            return rulePack;
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private void processRules(SMInputCursor rulesCursor, RulePack rulePack) throws XMLStreamException {
        SMInputCursor childCursor = rulesCursor.childCursor();
        while (childCursor.getNext() != null) {
            String nodeName = childCursor.getLocalName();
            if ("RuleDefinitions".equals(nodeName)) {
                this.processRuleDefinitions(childCursor, rulePack);
                continue;
            }
            if (!"Descriptions".equals(nodeName)) continue;
            this.processDescriptions(childCursor, rulePack);
        }
    }

    private void processDescriptions(SMInputCursor descriptionsCursor, RulePack rulePack) throws XMLStreamException {
        SMInputCursor descCursor = descriptionsCursor.childElementCursor("Description");
        while (descCursor.getNext() != null) {
            Description desc = this.processDescription(descCursor);
            rulePack.addDescription(desc);
        }
    }

    private Description processDescription(SMInputCursor descCursor) throws XMLStreamException {
        Description desc = new Description().setId(descCursor.getAttrValue("id")).setRef(descCursor.getAttrValue("ref"));
        SMInputCursor childCursor = descCursor.childCursor();
        while (childCursor.getNext() != null) {
            String nodeName = childCursor.getLocalName();
            if ("Abstract".equals(nodeName)) {
                desc.setDescriptionAbstract(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if ("Explanation".equals(nodeName)) {
                desc.setExplanation(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if ("Recommendations".equals(nodeName)) {
                desc.setRecommendations(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if (!"References".equals(nodeName)) continue;
            this.processReference(desc, childCursor);
        }
        return desc;
    }

    private void processReference(Description desc, SMInputCursor childCursor) throws XMLStreamException {
        SMInputCursor refCursor = childCursor.childElementCursor("Reference");
        while (refCursor.getNext() != null) {
            Reference reference = new Reference();
            SMInputCursor refChildCursor = refCursor.childCursor();
            while (refChildCursor.getNext() != null) {
                String refNodeName = refChildCursor.getLocalName();
                if ("Title".equals(refNodeName)) {
                    reference.setTitle(StringUtils.trim((String)refChildCursor.collectDescendantText(false)));
                    continue;
                }
                if (!"Author".equals(refNodeName)) continue;
                reference.setAuthor(StringUtils.trim((String)refChildCursor.collectDescendantText(false)));
            }
            desc.addReference(reference);
        }
    }

    private void processRuleDefinitions(SMInputCursor ruleDefsCursor, RulePack rulePack) throws XMLStreamException {
        SMInputCursor childCursor = ruleDefsCursor.childCursor();
        while (childCursor.getNext() != null) {
            String nodeName = childCursor.getLocalName();
            if (INTERNAL_RULE_NAMES.contains(nodeName) || !REAL_RULE_NAMES.contains(nodeName)) continue;
            this.processRule(childCursor, rulePack);
        }
    }

    private void processRule(SMInputCursor ruleCursor, RulePack rulePack) throws XMLStreamException {
        FortifyRule rule = new FortifyRule();
        rule.setLanguage(ruleCursor.getAttrValue("language"));
        rule.setFormatVersion(ruleCursor.getAttrValue("formatVersion"));
        SMInputCursor childCursor = ruleCursor.childCursor();
        while (childCursor.getNext() != null) {
            String nodeName = childCursor.getLocalName();
            if ("RuleID".equals(nodeName)) {
                rule.setRuleID(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if ("Notes".equals(nodeName)) {
                rule.setNotes(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if ("VulnKingdom".equals(nodeName)) {
                rule.setVulnKingdom(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if ("VulnCategory".equals(nodeName)) {
                rule.setVulnCategory(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if ("VulnSubcategory".equals(nodeName)) {
                rule.setVulnSubcategory(StringUtils.trim((String)childCursor.collectDescendantText(false)));
                continue;
            }
            if ("DefaultSeverity".equals(nodeName)) {
                rule.setDefaultSeverity(FortifyUtils.fortifyToSonarQubeSeverity(StringUtils.trim((String)childCursor.collectDescendantText(false))));
                continue;
            }
            if (!"Description".equals(nodeName)) continue;
            Description desc = this.processDescription(childCursor);
            rule.setDescription(desc);
        }
        rulePack.addRule(rule);
    }
}

