/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.rule.element;

import java.util.ArrayList;
import java.util.Collection;
import org.sonar.fortify.rule.element.Reference;

public class Description {
    private String id;
    private String ref;
    private String descriptionAbstract;
    private String explanation;
    private String recommendations;
    private final Collection<Reference> references = new ArrayList<Reference>();

    public String getId() {
        return this.id;
    }

    public Description setId(String id) {
        this.id = id;
        return this;
    }

    public String getRef() {
        return this.ref;
    }

    public Description setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public Description setDescriptionAbstract(String descriptionAbstract) {
        this.descriptionAbstract = descriptionAbstract;
        return this;
    }

    public Description setExplanation(String explanation) {
        this.explanation = explanation;
        return this;
    }

    public Description setRecommendations(String recommendations) {
        this.recommendations = recommendations;
        return this;
    }

    public String getRecommendations() {
        return this.recommendations;
    }

    public Description addReference(Reference reference) {
        this.references.add(reference);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.descriptionAbstract != null) {
            builder.append("<h2>ABSTRACT</h2><p>").append(this.descriptionAbstract).append("</p>");
        }
        if (this.explanation != null) {
            builder.append("<h2>EXPLANATION</h2><p>").append(this.explanation).append("</p>");
        }
        if (this.recommendations != null) {
            builder.append("<h2>RECOMMENDATIONS</h2><p>").append(this.recommendations).append("</p>");
        }
        if (!this.references.isEmpty()) {
            builder.append("<h2>REFERENCES</h2>");
            int index = 0;
            for (Reference reference : this.references) {
                builder.append("<p>[").append(index + 1).append("] ").append(reference.getTitle());
                if (reference.getAuthor() != null) {
                    builder.append(" - ").append(reference.getAuthor());
                }
                builder.append("</p>");
                ++index;
            }
        }
        return builder.toString();
    }
}

