/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.fortify.rule.element;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.sonar.fortify.rule.element.Description;
import org.sonar.fortify.rule.element.FormatVersion;

public class FortifyRule {
    private String language;
    private FormatVersion formatVersion;
    private String ruleID;
    private String notes;
    private String vulnKingdom;
    private String vulnCategory;
    private String vulnSubcategory;
    private String defaultSeverity;
    private Description description;

    public String getLanguage() {
        return this.language;
    }

    public FortifyRule setLanguage(String language) {
        this.language = language;
        return this;
    }

    public FormatVersion getFormatVersion() {
        return this.formatVersion;
    }

    public FortifyRule setFormatVersion(String formatVersion) {
        this.formatVersion = new FormatVersion(formatVersion);
        return this;
    }

    public String getRuleID() {
        return this.ruleID;
    }

    public FortifyRule setRuleID(String ruleID) {
        this.ruleID = ruleID;
        return this;
    }

    public FortifyRule setNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public FortifyRule setVulnCategory(String vulnCategory) {
        this.vulnCategory = vulnCategory;
        return this;
    }

    public FortifyRule setVulnKingdom(String vulnKingdom) {
        this.vulnKingdom = vulnKingdom;
        return this;
    }

    public FortifyRule setVulnSubcategory(String vulnSubcategory) {
        this.vulnSubcategory = vulnSubcategory;
        return this;
    }

    public String getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public FortifyRule setDefaultSeverity(String defaultSeverity) {
        this.defaultSeverity = defaultSeverity;
        return this;
    }

    public Description getDescription() {
        return this.description;
    }

    public FortifyRule setDescription(Description description) {
        this.description = description;
        return this;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getName() {
        if (StringUtils.isNotBlank((String)this.vulnCategory)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.vulnCategory);
            if (StringUtils.isNotBlank((String)this.vulnSubcategory)) {
                sb.append(": ");
                sb.append(this.vulnSubcategory);
            }
            return sb.toString();
        }
        if (StringUtils.isNotBlank((String)this.vulnSubcategory)) {
            return this.vulnSubcategory;
        }
        return this.ruleID;
    }

    public String[] getTags() {
        ArrayList<String> tags = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.vulnKingdom)) {
            tags.add(FortifyRule.slugify(this.vulnKingdom));
        }
        if (StringUtils.isNotBlank((String)this.vulnCategory)) {
            tags.add(FortifyRule.slugify(this.vulnCategory));
        }
        if (StringUtils.isNotBlank((String)this.vulnSubcategory)) {
            tags.add(FortifyRule.slugify(this.vulnSubcategory));
        }
        return tags.toArray(new String[tags.size()]);
    }

    private static String slugify(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replaceAll("[^\\w+]", "-").replaceAll("\\s+", "-").replaceAll("_", "-").replaceAll("[-]+", "-").replaceAll("^-", "").replaceAll("-$", "").toLowerCase(Locale.ENGLISH);
    }
}

