/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.JaCoCoSensor;

public class SurefireMavenPluginHandler
implements MavenPluginHandler {
    private static final String ARG_LINE_PARAMETER = "argLine";
    private static String agentPath;
    private HttpDownloader downloader;

    public SurefireMavenPluginHandler(HttpDownloader downloader) {
        this.downloader = downloader;
    }

    public String getGroupId() {
        return "org.apache.maven.plugins";
    }

    public String getArtifactId() {
        return "maven-surefire-plugin";
    }

    public String getVersion() {
        return "2.4.3";
    }

    public boolean isFixedVersion() {
        return false;
    }

    public String[] getGoals() {
        return new String[]{"test"};
    }

    protected String getAgentPath(Project project) {
        if (agentPath == null) {
            agentPath = this.downloadAgent(project);
        }
        return agentPath;
    }

    protected String getDownloadUrl(Project project) {
        String host = project.getConfiguration().getString("sonar.host.url", "http://localhost:9000");
        host = StringUtils.chomp((String)host, (String)"/");
        return host + "/deploy/plugins/sonar-jacoco-plugin/agent-all-0.4.0.20100604151516.jar";
    }

    private String downloadAgent(Project project) {
        try {
            URI uri = new URI(this.getDownloadUrl(project));
            File agent = File.createTempFile("jacocoagent", ".jar");
            this.downloader.download(uri, agent);
            FileUtils.forceDeleteOnExit((File)agent);
            LoggerFactory.getLogger(this.getClass()).info("Agent: {}", (Object)agent);
            return agent.getAbsolutePath();
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new SonarException((Throwable)e);
        }
    }

    public void configure(Project project, MavenPlugin surefirePlugin) {
        String argLine = surefirePlugin.getParameter(ARG_LINE_PARAMETER);
        String agent = "-javaagent:" + this.getAgentPath(project) + "=destfile=" + JaCoCoSensor.getPath(project);
        argLine = StringUtils.isBlank((String)argLine) ? agent : agent + " " + argLine;
        surefirePlugin.setParameter(ARG_LINE_PARAMETER, argLine);
    }
}

