/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonarplugin;

import com.hello2morrow.sonarplugin.ProjectContext;
import com.hello2morrow.sonarplugin.SonarJMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;

public final class AlertDecorator {
    private static AlertThreshold[] thresholds = new AlertThreshold[]{new AlertThreshold(SonarJMetrics.EROSION_DAYS, 5.0, 20.0), new AlertThreshold(SonarJMetrics.CYCLIC_ARTIFACTS, 2.0, 5.0), new AlertThreshold(SonarJMetrics.UNASSIGNED_TYPES, 1.0, 20.0), new AlertThreshold(SonarJMetrics.VIOLATING_TYPES, 10.0, 20.0), new AlertThreshold(SonarJMetrics.TASKS, 20.0, 50.0), new AlertThreshold(SonarJMetrics.THRESHOLD_WARNINGS, 20.0, 50.0), new AlertThreshold(SonarJMetrics.WORKSPACE_WARNINGS, 1.0, 10.0), new AlertThreshold(SonarJMetrics.CONSISTENCY_WARNINGS, 1.0, 10.0), new AlertThreshold(SonarJMetrics.NCCD, 6.5, 10.0), new AlertThreshold(SonarJMetrics.BIGGEST_CYCLE_GROUP, 4.0, 7.0), new AlertThreshold(SonarJMetrics.CYCLICITY, 25.0, 50.0)};

    private AlertDecorator() {
    }

    private static void copyAlertLevel(ProjectContext context, Metric from, Metric to) {
        Measure fromMeasure = context.getMeasure(from);
        if (fromMeasure != null) {
            Measure toMeasure = context.getMeasure(to);
            toMeasure.setAlertStatus(fromMeasure.getAlertStatus());
            context.saveMeasure(toMeasure);
        }
    }

    public static void setAlertLevels(ProjectContext context) {
        for (AlertThreshold threshold : thresholds) {
            Measure m = context.getMeasure(threshold.getMetric());
            if (m == null) continue;
            m.setAlertStatus(threshold.getLevel(m.getValue()));
            context.saveMeasure(m);
        }
        AlertDecorator.copyAlertLevel(context, SonarJMetrics.NCCD, SonarJMetrics.ACD);
        AlertDecorator.copyAlertLevel(context, SonarJMetrics.EROSION_DAYS, SonarJMetrics.EROSION_COST);
        AlertDecorator.copyAlertLevel(context, SonarJMetrics.VIOLATING_TYPES, SonarJMetrics.ARCHITECTURE_VIOLATIONS);
        AlertDecorator.copyAlertLevel(context, SonarJMetrics.TASKS, SonarJMetrics.TASK_REFS);
        AlertDecorator.copyAlertLevel(context, SonarJMetrics.TASKS, SonarJMetrics.TASK_REFS);
        AlertDecorator.copyAlertLevel(context, SonarJMetrics.CYCLICITY, SonarJMetrics.RELATIVE_CYCLICITY);
    }

    static class AlertThreshold {
        private Metric metric;
        private double warningLevel;
        private double alertLevel;

        AlertThreshold(Metric metric, double warningLevel, double alertLevel) {
            this.metric = metric;
            this.warningLevel = warningLevel;
            this.alertLevel = alertLevel;
        }

        Metric getMetric() {
            return this.metric;
        }

        Metric.Level getLevel(double value) {
            if (value >= this.alertLevel) {
                return Metric.Level.ERROR;
            }
            if (value >= this.warningLevel) {
                return Metric.Level.WARN;
            }
            return Metric.Level.OK;
        }
    }
}

