/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonarplugin;

import com.hello2morrow.sonarplugin.AlertDecorator;
import com.hello2morrow.sonarplugin.DecoratorProjectContext;
import com.hello2morrow.sonarplugin.SonarJMetrics;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.AbstractSumChildrenDecorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SonarJMetricAggregator
extends AbstractSumChildrenDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(SonarJMetricAggregator.class);

    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Arrays.asList(SonarJMetrics.VIOLATING_TYPES, SonarJMetrics.CYCLIC_ARTIFACTS, SonarJMetrics.CYCLIC_PACKAGES, SonarJMetrics.CYCLICITY, SonarJMetrics.EROSION_DAYS, SonarJMetrics.EROSION_COST, SonarJMetrics.EROSION_REFS, SonarJMetrics.EROSION_TYPES, SonarJMetrics.IGNORED_VIOLATONS, SonarJMetrics.IGNORED_WARNINGS, SonarJMetrics.INSTRUCTIONS, SonarJMetrics.INTERNAL_PACKAGES, SonarJMetrics.INTERNAL_TYPES, SonarJMetrics.JAVA_FILES, SonarJMetrics.TASKS, SonarJMetrics.TASK_REFS, SonarJMetrics.THRESHOLD_WARNINGS, SonarJMetrics.TYPE_DEPENDENCIES, SonarJMetrics.VIOLATING_DEPENDENCIES, SonarJMetrics.ARCHITECTURE_VIOLATIONS);
    }

    protected boolean shouldSaveZeroIfNoChildMeasures() {
        return false;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(resource)) {
            return;
        }
        if (context.getChildrenMeasures(SonarJMetrics.INSTRUCTIONS).size() == 0) {
            return;
        }
        super.decorate(resource, context);
        double biggestCycleGroupSize = -1.0;
        for (DecoratorContext childContext : context.getChildren()) {
            Measure m = childContext.getMeasure(SonarJMetrics.BIGGEST_CYCLE_GROUP);
            if (m == null || !(m.getValue() > biggestCycleGroupSize)) continue;
            biggestCycleGroupSize = m.getValue();
        }
        if (biggestCycleGroupSize >= 0.0 && context.getMeasure(SonarJMetrics.BIGGEST_CYCLE_GROUP) == null) {
            context.saveMeasure(SonarJMetrics.BIGGEST_CYCLE_GROUP, Double.valueOf(biggestCycleGroupSize));
        }
        Measure cyclicity = context.getMeasure(SonarJMetrics.CYCLICITY);
        Measure packages = context.getMeasure(SonarJMetrics.INTERNAL_PACKAGES);
        if (cyclicity == null || packages == null) {
            LOG.error("Problem in aggregator on project: " + context.getProject().getKey());
        } else {
            double relCyclicity = 100.0 * Math.sqrt(cyclicity.getValue()) / packages.getValue();
            context.saveMeasure(SonarJMetrics.RELATIVE_CYCLICITY, Double.valueOf(relCyclicity));
        }
        Measure violatingTypes = context.getMeasure(SonarJMetrics.VIOLATING_TYPES);
        Measure internalTypes = context.getMeasure(SonarJMetrics.INTERNAL_TYPES);
        if (violatingTypes != null && internalTypes != null) {
            context.saveMeasure(SonarJMetrics.VIOLATING_TYPES_PERCENT, Double.valueOf(100.0 * violatingTypes.getValue() / internalTypes.getValue()));
        }
        AlertDecorator.setAlertLevels(new DecoratorProjectContext(context));
    }

    public boolean shouldDecorateResource(Resource resource) {
        return Arrays.asList("TRK", "BRC").contains(resource.getQualifier());
    }
}

