/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import shade.javax.activation.DataHandler;
import shade.javax.activation.DataSource;
import shade.javax.activation.MimeType;
import shade.javax.activation.MimeTypeParseException;

public final class DataSourceSource
extends StreamSource {
    private final DataSource source;
    private final String charset;

    public DataSourceSource(DataHandler dh) throws MimeTypeParseException {
        this(dh.getDataSource());
    }

    public DataSourceSource(DataSource source) throws MimeTypeParseException {
        this.source = source;
        String ct = source.getContentType();
        if (ct == null) {
            this.charset = null;
        } else {
            MimeType mimeType = new MimeType(ct);
            this.charset = mimeType.getParameter("charset");
        }
    }

    public void setReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    public void setInputStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public Reader getReader() {
        try {
            if (this.charset == null) {
                return null;
            }
            return new InputStreamReader(this.source.getInputStream(), this.charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() {
        try {
            if (this.charset == null) {
                return this.source.getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DataSource getDataSource() {
        return this.source;
    }
}

