/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.totalquality;

import java.util.List;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.plugins.totalquality.AbstractBaseDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDesignDecorator
extends AbstractBaseDecorator {
    abstract List<Metric> generatesMetrics();

    double doFileDecoration(Resource resource, DecoratorContext context, Metric orig, int aceleration, double cota) {
        double top;
        Measure measure = context.getMeasure(orig);
        double metric = measure != null ? measure.getValue() : 0.0;
        double d = top = aceleration <= 1 ? cota : (double)aceleration * cota;
        double value = metric <= cota ? 100.0 : (metric > top ? 0.0 : ParsingUtils.scaleValue((double)((1.0 - (metric - cota) / (top - cota)) * 100.0), (int)2));
        return value;
    }

    @Override
    void decorateDir(Resource resource, DecoratorContext context) {
        List children = context.getChildren();
        if (children != null && !children.isEmpty()) {
            List<Metric> metrics = this.generatesMetrics();
            for (Metric metric : metrics) {
                double sum = 0.0;
                double size = 0.0;
                for (DecoratorContext dc : children) {
                    Measure measure;
                    Resource c = dc.getResource();
                    if (c.getQualifier().equals("UTS") || (measure = dc.getMeasure(metric)) == null || measure.getValue() == null) continue;
                    sum += measure.getValue().doubleValue();
                    size += 1.0;
                }
                double value = size > 0.0 ? sum / size : -1.0;
                if (value == -1.0) continue;
                context.saveMeasure(new Measure(metric, Double.valueOf(ParsingUtils.scaleValue((double)value, (int)2))));
            }
        }
    }

    @Override
    void decorateProj(Resource resource, DecoratorContext context) {
        this.decorateDir(resource, context);
    }
}

