/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.totalquality;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.totalquality.AbstractDecorator;
import org.sonar.plugins.totalquality.TQMetrics;

public abstract class AbstractFormulaBasedDecorator
extends AbstractDecorator {
    public abstract Metric generatesMetric();

    protected abstract String getLine(DecoratorContext var1);

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldSaveMeasure(resource) && this.hasCode(context)) {
            String line = this.getLine(context);
            Double value = this.solve(context, line);
            context.saveMeasure(this.generatesMetric(), value);
        }
    }

    protected Double solve(DecoratorContext context, String formula) {
        double sum = 0.0;
        String[] params = formula.split(" ");
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i].split("=");
            Metric metric = TQMetrics.formulaParams.get(param[0]);
            Double mod = Double.parseDouble(param[1]);
            Measure measure = context.getMeasure(metric);
            if (!MeasureUtils.hasValue((Measure)measure)) continue;
            double value = measure.getValue() * mod;
            sum += value;
        }
        return sum;
    }
}

