/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.totalquality;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.plugins.totalquality.AbstractBaseDecorator;
import org.sonar.plugins.totalquality.TQMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectureADIDecorator
extends AbstractBaseDecorator {
    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Arrays.asList(TQMetrics.TQ_ARCHITECTURE_ADI);
    }

    @DependsUpon
    public List<Metric> dependsOnMetrics() {
        return Arrays.asList(CoreMetrics.DISTANCE, CoreMetrics.NCLOC);
    }

    @Override
    public void decorate(Resource resource, DecoratorContext context) {
    }

    @Override
    void decorateDir(Resource resource, DecoratorContext context) {
        double distance;
        int aceleration = context.getProject().getConfiguration().getInt("tq.acel", Integer.parseInt("2"));
        double cota = context.getProject().getConfiguration().getDouble("tq.architecture.adi", Double.parseDouble("20.0"));
        double top = aceleration <= 1 ? cota : (double)aceleration * cota;
        Measure measure = context.getMeasure(CoreMetrics.DISTANCE);
        double d = distance = measure == null || measure.getValue() == null ? 0.0 : measure.getValue();
        double res = distance <= cota ? 1.0 : (distance > top ? 0.0 : 1.0 - (distance - cota) / (top - cota));
        context.saveMeasure(TQMetrics.TQ_ARCHITECTURE_ADI, Double.valueOf(ParsingUtils.scaleValue((double)(res * 100.0), (int)2)));
    }

    @Override
    void decorateFile(Resource resource, DecoratorContext context) {
        context.saveMeasure(TQMetrics.TQ_ARCHITECTURE_ADI, Double.valueOf(ParsingUtils.scaleValue((double)100.0, (int)2)));
    }

    @Override
    void decorateProj(Resource resource, DecoratorContext context) {
        Collection measures = context.getChildrenMeasures(TQMetrics.TQ_ARCHITECTURE_ADI);
        if (measures == null || measures.size() == 0) {
            return;
        }
        double total = 0.0;
        double size = 0.0;
        for (Measure m : measures) {
            if (!MeasureUtils.hasValue((Measure)m)) continue;
            total += m.getValue().doubleValue();
            size += 1.0;
        }
        double value = size > 0.0 ? total / size / 100.0 : 0.0;
        context.saveMeasure(TQMetrics.TQ_ARCHITECTURE_ADI, Double.valueOf(ParsingUtils.scaleValue((double)(value * 100.0), (int)2)));
    }
}

