/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.totalquality;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.plugins.totalquality.AbstractBaseDecorator;
import org.sonar.plugins.totalquality.TQMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitecturePTIDecorator
extends AbstractBaseDecorator {
    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Arrays.asList(TQMetrics.TQ_ARCHITECTURE_PTI);
    }

    @DependsUpon
    public List<Metric> dependsOnMetrics() {
        return Arrays.asList(CoreMetrics.PACKAGE_TANGLE_INDEX, CoreMetrics.FILE_TANGLE_INDEX, CoreMetrics.NCLOC);
    }

    @Override
    void decorateFile(Resource resource, DecoratorContext context) {
    }

    @Override
    void decorateDir(Resource resource, DecoratorContext context) {
        this.doDecoration(resource, context, CoreMetrics.FILE_TANGLE_INDEX);
    }

    private void doDecoration(Resource resource, DecoratorContext context, Metric metric) {
        Measure measure = context.getMeasure(metric);
        double pti = MeasureUtils.hasValue((Measure)measure) ? 100.0 - measure.getValue() : 100.0;
        context.saveMeasure(TQMetrics.TQ_ARCHITECTURE_PTI, Double.valueOf(ParsingUtils.scaleValue((double)pti, (int)2)));
    }

    @Override
    void decorateProj(Resource resource, DecoratorContext context) {
        this.doDecoration(resource, context, CoreMetrics.PACKAGE_TANGLE_INDEX);
    }
}

