/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.totalquality;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.totalquality.AbstractDecorator;
import org.sonar.plugins.totalquality.TQMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrynessDecorator
extends AbstractDecorator {
    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Arrays.asList(TQMetrics.TQ_DRY);
    }

    @DependsUpon
    public List<Metric> dependsOnMetrics() {
        return Arrays.asList(CoreMetrics.DUPLICATED_LINES_DENSITY);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.hasCode(context) && this.shouldSaveMeasure(resource)) {
            Double value = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.DUPLICATED_LINES_DENSITY), (Double)0.0);
            Double dry = 100.0 - value;
            context.saveMeasure(TQMetrics.TQ_DRY, dry);
        }
    }

    @Override
    public boolean shouldSaveMeasure(Resource resource) {
        return super.shouldSaveMeasure(resource) && this.isProj(resource);
    }
}

