/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.totalquality;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TQMetrics
implements Metrics {
    public static String DOMAIN_ARCHITECTURE = "Architecture";
    public static final String TQ_TOTAL_QUALITY_KEY = "total-quality";
    public static final Metric TQ_TOTAL_QUALITY = new Metric("total-quality", "Total Quality", "The total quality of a project", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "General");
    public static final String TQ_DRY_KEY = "total-quality-dry";
    public static final Metric TQ_DRY = new Metric("total-quality-dry", "DRYness", "DRY = 100 - duplicated_lines_density", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Duplication");
    public static final String TQ_CODE_KEY = "total-quality-code";
    public static final Metric TQ_CODE = new Metric("total-quality-code", "Code Quality", "CODE quality from public_documented_api_density, violations_density and total-quality-dry", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Rules");
    public static final String TQ_TS_KEY = "total-quality-test";
    public static final Metric TQ_TS = new Metric("total-quality-test", "Testing Quality", "TS quality from branch_coverage, line_coverage and coverage", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Tests");
    public static final String TQ_DESIGN_NOM_KEY = "total-quality-design-nom";
    public static final Metric TQ_DESIGN_NOM = new Metric("total-quality-design-nom", "Design Classes and Methods Complexity", "NOM from classes with function_complexity gt value (2.5 default) and class_complexity gt value (12 default)", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Design");
    public static final String TQ_DESIGN_LCOM4_KEY = "total-quality-design-lcom4";
    public static final Metric TQ_DESIGN_LCOM4 = new Metric("total-quality-design-lcom4", "Design Lack of Cohesion of Methods", "LCOM4 from classes with lcom4 gt vale (50 default)", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Design");
    public static final String TQ_DESIGN_RFC_KEY = "total-quality-design-rfc";
    public static final Metric TQ_DESIGN_RFC = new Metric("total-quality-design-rfc", "Design Response for Class", "RFC from classes with rfc gt vale (50 default)", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Design");
    public static final String TQ_DESIGN_CBO_KEY = "total-quality-design-cbo";
    public static final Metric TQ_DESIGN_CBO = new Metric("total-quality-design-cbo", "Design Coupling Between Objects", "CBO from classes with ce gt value (5 default)", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Design");
    public static final String TQ_DESIGN_DIT_KEY = "total-quality-design-dit";
    public static final Metric TQ_DESIGN_DIT = new Metric("total-quality-design-dit", "Design Depth of Inheritance Tree", "DIT from classes with dit gt value (5 default)", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Design");
    public static final String TQ_DESIGN_KEY = "total-quality-design";
    public static final Metric TQ_DESIGN = new Metric("total-quality-design", "Design Quality", "DES from total-quality-design-dit, total-quality-design-cbo, total-quality-design-lcom4, total-quality-design-rfc and total-quality-design-nom", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), "Design");
    public static final String TQ_ARCHITECTURE_PTI_KEY = "total-quality-architecture-pti";
    public static final Metric TQ_ARCHITECTURE_PTI = new Metric("total-quality-architecture-pti", "Architecture Tangle Index", "Inverse of Packages and files tangle index", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), DOMAIN_ARCHITECTURE);
    public static final String TQ_ARCHITECTURE_ADI_KEY = "total-quality-architecture-adi";
    public static final Metric TQ_ARCHITECTURE_ADI = new Metric("isoqa_architecture_adi", "Architecture Distance", "ADI from distance gt value (20 default)", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), DOMAIN_ARCHITECTURE);
    public static final String TQ_ARCHITECTURE_KEY = "total-quality-architecture";
    public static final Metric TQ_ARCHITECTURE = new Metric("total-quality-architecture", "Architecture", "ARCH from total-quality-architecture-adi and package_tangle_index", Metric.ValueType.PERCENT, Integer.valueOf(1), Boolean.valueOf(true), DOMAIN_ARCHITECTURE);
    public static final Map<String, Metric> formulaParams = ImmutableMap.builder().put((Object)"ARCH", (Object)TQ_ARCHITECTURE).put((Object)"DESIGN", (Object)TQ_DESIGN).put((Object)"CODE", (Object)TQ_CODE).put((Object)"TESTS", (Object)TQ_TS).put((Object)"NOM", (Object)TQ_DESIGN_NOM).put((Object)"LCOM", (Object)TQ_DESIGN_LCOM4).put((Object)"RFC", (Object)TQ_DESIGN_RFC).put((Object)"CBO", (Object)TQ_DESIGN_CBO).put((Object)"DIT", (Object)TQ_DESIGN_DIT).put((Object)"PTI", (Object)TQ_ARCHITECTURE_PTI).put((Object)"ADI", (Object)TQ_ARCHITECTURE_ADI).put((Object)"COV", (Object)CoreMetrics.COVERAGE).put((Object)"SUC", (Object)CoreMetrics.TEST_SUCCESS_DENSITY).put((Object)"DOC", (Object)CoreMetrics.PUBLIC_DOCUMENTED_API_DENSITY).put((Object)"RULES", (Object)CoreMetrics.VIOLATIONS_DENSITY).put((Object)"DRY", (Object)TQ_DRY).build();

    public List<Metric> getMetrics() {
        return Arrays.asList(TQ_TOTAL_QUALITY, TQ_DRY, TQ_CODE, TQ_TS, TQ_DESIGN_NOM, TQ_DESIGN_RFC, TQ_DESIGN_CBO, TQ_DESIGN_DIT, TQ_DESIGN_LCOM4, TQ_DESIGN, TQ_ARCHITECTURE_ADI, TQ_ARCHITECTURE_PTI, TQ_ARCHITECTURE);
    }
}

