/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.protocol.input;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class ActiveRule {
    private final String repositoryKey;
    private final String ruleKey;
    private final String name;
    private final String severity;
    private final String internalKey;
    private final String language;
    private final Map<String, String> params = new HashMap<String, String>();

    public ActiveRule(String repositoryKey, String ruleKey, String name, String severity, @Nullable String internalKey, String language) {
        this.repositoryKey = repositoryKey;
        this.ruleKey = ruleKey;
        this.name = name;
        this.severity = severity;
        this.internalKey = internalKey;
        this.language = language;
    }

    public String repositoryKey() {
        return this.repositoryKey;
    }

    public String ruleKey() {
        return this.ruleKey;
    }

    public String name() {
        return this.name;
    }

    public String severity() {
        return this.severity;
    }

    public String language() {
        return this.language;
    }

    @CheckForNull
    public String param(String key) {
        return this.params.get(key);
    }

    public ActiveRule addParam(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public Map<String, String> params() {
        return this.params;
    }

    @CheckForNull
    public String internalKey() {
        return this.internalKey;
    }
}

