/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.protocol.input;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.batch.protocol.input.ActiveRule;
import org.sonar.batch.protocol.input.FileData;
import org.sonar.batch.protocol.input.QProfile;

public class ProjectReferentials {
    private long timestamp;
    private Map<String, QProfile> qprofilesByLanguage = new HashMap<String, QProfile>();
    private Collection<ActiveRule> activeRules = new ArrayList<ActiveRule>();
    private Map<String, Map<String, String>> settingsByModule = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, FileData>> fileDataByModuleAndPath = new HashMap<String, Map<String, FileData>>();
    private Date lastAnalysisDate;

    public Map<String, String> settings(String projectKey) {
        return this.settingsByModule.containsKey(projectKey) ? this.settingsByModule.get(projectKey) : Collections.emptyMap();
    }

    public ProjectReferentials addSettings(String projectKey, Map<String, String> settings) {
        Map<String, String> existingSettings = this.settingsByModule.get(projectKey);
        if (existingSettings == null) {
            existingSettings = new HashMap<String, String>();
            this.settingsByModule.put(projectKey, existingSettings);
        }
        existingSettings.putAll(settings);
        return this;
    }

    public Collection<QProfile> qProfiles() {
        return this.qprofilesByLanguage.values();
    }

    public ProjectReferentials addQProfile(QProfile qProfile) {
        this.qprofilesByLanguage.put(qProfile.language(), qProfile);
        return this;
    }

    public Collection<ActiveRule> activeRules() {
        return this.activeRules;
    }

    public ProjectReferentials addActiveRule(ActiveRule activeRule) {
        this.activeRules.add(activeRule);
        return this;
    }

    public Map<String, FileData> fileDataByPath(String projectKey) {
        return this.fileDataByModuleAndPath.containsKey(projectKey) ? this.fileDataByModuleAndPath.get(projectKey) : Collections.emptyMap();
    }

    public ProjectReferentials addFileData(String projectKey, String path, FileData fileData) {
        Map<String, FileData> existingFileDataByPath = this.fileDataByModuleAndPath.get(projectKey);
        if (existingFileDataByPath == null) {
            existingFileDataByPath = new HashMap<String, FileData>();
            this.fileDataByModuleAndPath.put(projectKey, existingFileDataByPath);
        }
        existingFileDataByPath.put(path, fileData);
        return this;
    }

    @CheckForNull
    public FileData fileData(String projectKey, String path) {
        return this.fileDataByPath(projectKey).get(path);
    }

    public long timestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @CheckForNull
    public Date lastAnalysisDate() {
        return this.lastAnalysisDate;
    }

    public void setLastAnalysisDate(@Nullable Date lastAnalysisDate) {
        this.lastAnalysisDate = lastAnalysisDate;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        return gson.toJson((Object)this);
    }

    public static ProjectReferentials fromJson(String json) {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        return (ProjectReferentials)gson.fromJson(json, ProjectReferentials.class);
    }
}

